#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npthreads.h"

np_thread_node_t *NP_Threads::get_spool_beginning()
{
   return spool_beginning;
}

void NP_Threads::get_totals( int *totalp, int *headersp,
                             int *unseenp, int *requestsp )
{
   if ( totalp != NULL )
      *totalp = total;

   if ( headersp != NULL )
      *headersp = headers;

   if ( unseenp != NULL )
      *unseenp = unseen;

   if ( requestsp != NULL )
      *requestsp = requested;

   return;
}

np_thread_node_t *NP_Threads::get_tree( char *new_server, char *new_group,
                                        int hide_seen, int hide_headers,
                                        int destroy )
{
   if ( destroy && threads != NULL )
      clear();

   threads = NULL;

   if ( new_server == NULL )
   {
      strcpy( error_message, "NP_Threads: get_tree(): NULL server address "
              "passed as argument." );
      return NULL;
   }

   if ( server != NULL )
      free( server );

   if (( server = strdup( new_server )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   if ( new_group == NULL )
   {
      strcpy( error_message, "NP_Threads: get_tree(): NULL group name "
              "passed as argument." );
      return NULL;
   }

   if ( group != NULL )
      free( group );

   if (( group = strdup( new_group )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   if ( make( hide_seen, hide_headers ) )
      return NULL;
   
   return threads;
}

int NP_Threads::make( int hide_seen, int hide_headers )
{
   int result;
   
   if (( result = load( server, group, hide_seen, hide_headers )))
   {
      if ( result == 2 )
         return 0;

      return 1;
   }

   if (( result = sort()))
      return 1;

   if (( result = thread()))
      return 1;

   if (( result = fill_gaps()))
      return 1;

   return 0;
}
