#include <signal.h>

#include "npsummary.h"

extern void *summary_p;

void SIGUSR2_handler( int signo )
{
   NP_Summary *summary = ( NP_Summary *)summary_p;

   summary->write_read_file();

   summary->threads.clear();
   if ( summary->tree_widget != NULL )
   {
      gtk_widget_destroy( summary->tree_widget );
      summary->tree_widget = NULL;
      gtk_widget_show( summary->scroll );
   }
   
   summary->tree = summary->current_node = summary->spool_beginning = NULL;

   summary->total = summary->unseen = summary->headers =
      summary->requested = 0;
   
   if ( summary->text_pid )
      kill( summary->text_pid, SIGUSR1 );

   signal( SIGUSR2, SIGUSR2_handler );

   return;
}
