#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>

char *label_string = NULL;

void close_callback( GtkWidget *widget, gpointer data )
{
   if ( label_string != NULL )
      free( label_string );

   gtk_main_quit();
   return;
}

char *insert_newlines( char *before )
{
   char *after;

   if (( label_string = ( char *)malloc( strlen( before ) + 1 )) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   after = label_string;

   while( *before )
   {
      if ( *before == '\\' && *( before + 1 ) == 'n' )
      {
         *after++ = '\n';
         before += 2;
      }
      else
         *after++ = *before++;
   }

   *after = '\0';

   return label_string; 
}


int main( int argc, char **argv )
{
   if ( argc < 2 )
   {
      fprintf( stderr, "usage: npfeedback 'message text'\n" );
      return 1;
   }

   gtk_init( &argc, &argv );

   GtkWidget *window = gtk_window_new( GTK_WINDOW_DIALOG );
   gtk_container_border_width( GTK_CONTAINER( window ), 10 );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_callback ), NULL );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( close_callback ), NULL );
   gtk_window_set_title( GTK_WINDOW( window ), 
                         "Feedback Dialog" );

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_add( GTK_CONTAINER( window ), frame );

   GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( vbox );
   gtk_container_border_width( GTK_CONTAINER( vbox ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), vbox );

   GtkWidget *label = gtk_label_new( insert_newlines( argv[ 1 ] ));
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 10 );

   GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );

   GtkWidget *button = gtk_button_new_with_label( " OK " );
   gtk_widget_show( button );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( close_callback ), NULL );
   gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );

   gtk_widget_show( window );

   gtk_main();

   return 0;
}
