#include "npconfig.h"

void sort_folders_callback( GtkWidget *widget, gpointer data )
{
   NP_Folders *folders
      = ( NP_Folders *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                            "object" );

   int total;
   if (( total = folders->get_total() ) < 0 )
   {
      folders->print_error();
      return;
   }

   if ( !total )
      return;

   if ( folders->sort() )
   {
      folders->print_error();
      return;
   }

   GtkWidget *clist =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "clist" );

   gtk_clist_freeze( GTK_CLIST( clist ));
   gtk_clist_clear( GTK_CLIST( clist ));

   for( int i = 0; i < total; ++i )
   {
      char *lines[ 2 ];
      if ( folders->get_items( i, &lines[ 0 ], &lines[ 1 ] ))
      {
         folders->print_error();
         return;
      }

      gtk_clist_append( GTK_CLIST( clist ), lines );
   }

   gtk_clist_thaw( GTK_CLIST( clist ));

   NP_Config *config = ( NP_Config *)data;
   config->folder_clist_line = -1;
   
   return;
}
