#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npfolders.h"

int NP_Folders::load( char *path )
{
   clear();

   if (( folders_path = strdup( path )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }
   
   if ( folders_file.openr( folders_path ))
      if ( errno != ENOENT )
      {
         folders_file.print_error();
         return 1;
      }

   int count = 0;
   char *line;

   while(( line = folders_file.get_string() ) != NULL )
   {
      if ( strtok( line, "\n" ) == NULL )
      {
         snprintf( error_message, sizeof error_message,
                   "NP_Folders: load(): malformed line %d in "
                   "~/.peruser4-Folders.", count );
         return 1;
      }

      if ( name_list.add_item( line + strspn( line, ":" )))
      {
         name_list.print_error();
         return 1;
      }
   }

   folders_file.close();

   return 0;
}
