#include "npconfig.h"

void folder_clist_callback( GtkWidget *widget, gint r, gint c,
                            GdkEvent *event, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;
   
   if ( config->folder_clist_line == r )
   {
      config->folder_clist_line = -1;
      return;
   }
   else
      config->folder_clist_line = r;

   char *line[ 2 ];
   gtk_clist_get_text( GTK_CLIST( widget ), r, 0, &line[ 0 ] );
   gtk_clist_get_text( GTK_CLIST( widget ), r, 1, &line[ 1 ] );

   GtkWidget *entry =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget ),
                                         "name_entry" );

   gtk_entry_set_text( GTK_ENTRY( entry ), line[ 0 ] );

   entry = ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                              "filter_entry" );

   if ( entry != NULL )
      gtk_entry_set_text( GTK_ENTRY( entry ), line[ 1 ] );
   
   return;
}

