#include <errno.h>
#include "npconfig.h"

void dialog_remove_callback( GtkWidget *widget, gpointer data )
{
   int i = ( int)gtk_object_get_data( GTK_OBJECT( widget ), "button" );

   GtkWidget *entry = ( GtkWidget *)data;

   GtkWidget *window =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( entry ), "window" );

   NP_Config *config =
      ( NP_Config *)gtk_object_get_data( GTK_OBJECT( entry ), "config" );

   char *server = gtk_entry_get_text( GTK_ENTRY( entry ));

   if ( i )
   {
      int j;
      if (( j = config->subscription[ server ] ) < 0 )
      {
         config->show_message( config->subscription.get_error(), 0 );
         return;
      }

      int total = config->subscription.get_total_groups( j );
      if ( total < 0 )
      {
         config->subscription.print_error();
         return;
      }

      if ( total )
      {
         for( int i = 0; i < total; ++ i )
         {
            char *group = ( char *)config->subscription.get_group( j, i );
            if ( group == NULL )
            {
               config->subscription.print_error();
               return;
            }
            char buffer[ 512 ];
            snprintf( buffer, sizeof buffer, "%s-%s", server, group );
            if ( config->deleted.add_item( buffer ))
               config->deleted.print_error();
         }
      }

      char listfile[ 1024 ];
      snprintf( listfile, sizeof listfile, "%s-LIST", server );
      char posted[ 1024 ];
      snprintf( posted, sizeof posted, "%s-POSTED", server );
      char timestamp[ 1024 ];
      snprintf( timestamp, sizeof timestamp, "%s-TIMESTAMP", server );
      char follow_ups[ 1024 ];
      snprintf( follow_ups, sizeof follow_ups, "%s-FOLLOW-UPS", server );
      
      if ( config->deleted.add_item( listfile ) ||
           config->deleted.add_item( posted ) ||
           config->deleted.add_item( timestamp ) ||
           config->deleted.add_item( follow_ups ))
         config->deleted.print_error();
         
      if ( config->subscription.remove_server( server ))
      {
         config->subscription.print_error();
         return;
      }
   
      config->dirty = 1;

      config->update_server_frames( j );
      config->update_server_buttons( j );
   }

   gtk_grab_remove( window );
   gtk_widget_destroy( window );

   if ( config->server_buttons != NULL )
   {
      GTK_TOGGLE_BUTTON( config->server_buttons[ 0 ] )->active = TRUE;
      gtk_widget_set_state( GTK_WIDGET( config->server_buttons[ 0 ] ),
                            GTK_STATE_ACTIVE );
      address_buttons_callback( config->server_buttons[ 0 ],
                                ( char *)config->subscription[ 0 ] );
   }
   else
   {
      gtk_clist_set_column_title( GTK_CLIST( config->group_clist ),
                                  0, "0 Subscribed Newsgroups" );
      config->current_server = -1;
   }

   return;
}


