#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void transfer_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( collections->search_shown )
      gtk_clist_clear( GTK_CLIST( collections->search_clist ));

   collections->transfer_what = 0;
   collections->transfer_quantity = 0;

   char *server = NULL, *group_name = NULL;

   if ( collections->selected_item != NULL )
   {
      server =
         ( char *)gtk_object_get_data(
            GTK_OBJECT( collections->selected_item ), "server" );

      group_name =
         ( char *)gtk_object_get_data(
            GTK_OBJECT( collections->selected_item ), "group" );
   }

   if ( group_name != NULL &&
        ( !strcmp( group_name, "FOLLOW-UPS" ) ||
          !strcmp( group_name, "OUTBOX" )))
   {
      pack_button_callback( ( GtkWidget *)2, data );
      return;
   }

   if ( server != NULL && !strcmp( server, "Folders" ))
   {
      pack_button_callback( ( GtkWidget *)2, data );
      return;
   }

   if ( group_name != NULL &&
        ( !strcmp( group_name, "POSTED" ) ||
          !strcmp( group_name, "SENT-MAIL" )))
      return;
   
   collections->transfer_window = gtk_window_new( GTK_WINDOW_DIALOG );
   gtk_window_position( GTK_WINDOW( collections->transfer_window ),
                        GTK_WIN_POS_MOUSE );
   gtk_widget_set_usize( collections->transfer_window, 450, 215 );

   GtkWidget *top_vbox = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( top_vbox );
   gtk_container_border_width( GTK_CONTAINER( top_vbox ), 10 );
   gtk_container_add( GTK_CONTAINER( collections->transfer_window ),
                      top_vbox );

   GtkWidget *label =
      gtk_label_new( "FOR NEWSGROUPS, WHAT SHOULD I RETRIEVE?" );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( top_vbox ), label, FALSE, FALSE, 0 );

   GtkWidget *hbox = gtk_hbox_new( FALSE, 10 );
   gtk_widget_show( hbox );
   gtk_container_add( GTK_CONTAINER( top_vbox ), hbox );

   GtkWidget *frame = gtk_frame_new( "Kind:" );
   gtk_widget_show( frame );
   gtk_container_add( GTK_CONTAINER( hbox ), frame );

   GtkWidget *vbox = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( frame ), vbox );
   gtk_container_border_width( GTK_CONTAINER( vbox ), 10 );

   GtkWidget *button = gtk_radio_button_new_with_label( NULL, "Headers Only" );
   gtk_widget_show( button );
   gtk_signal_connect( GTK_OBJECT( button ), "pressed",
                       GTK_SIGNAL_FUNC( radio_buttons_callback ), data );
   gtk_object_set_data( GTK_OBJECT( button ), "what", ( gpointer )0 );
   gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
   GSList *group = gtk_radio_button_group( GTK_RADIO_BUTTON( button ));

   button = gtk_radio_button_new_with_label( group, "Full Articles" );
   gtk_widget_show( button );
   gtk_signal_connect( GTK_OBJECT( button ), "pressed",
                       GTK_SIGNAL_FUNC( radio_buttons_callback ), data );
   gtk_object_set_data( GTK_OBJECT( button ), "what", ( gpointer )1 );
   gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
   group = gtk_radio_button_group( GTK_RADIO_BUTTON( button ));

   button = gtk_radio_button_new_with_label( group, "Requested Articles" );
   gtk_widget_show( button );
   gtk_signal_connect( GTK_OBJECT( button ), "pressed",
                       GTK_SIGNAL_FUNC( radio_buttons_callback ),
                       data );
   gtk_object_set_data( GTK_OBJECT( button ), "what", ( gpointer )2 );
   gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );

   collections->quantity_frame = gtk_frame_new( "Quantity:" );
   gtk_widget_show( collections->quantity_frame );
   gtk_container_add( GTK_CONTAINER( hbox ), collections->quantity_frame );

   vbox = gtk_vbox_new( FALSE, 10 );
   gtk_object_set_data( GTK_OBJECT( collections->quantity_frame ), "widget",
                        vbox );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( collections->quantity_frame ), vbox );
   gtk_container_border_width( GTK_CONTAINER( vbox ), 10 );
   
   button = gtk_radio_button_new_with_label( NULL, "All Unseen" );
   gtk_object_set_data( GTK_OBJECT( vbox ), "widget", button );
   gtk_widget_show( button );
   gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
   gtk_signal_connect( GTK_OBJECT( button ), "pressed",
                       GTK_SIGNAL_FUNC( radio_buttons_callback ), data );
   gtk_object_set_data( GTK_OBJECT( button ), "what", ( gpointer )10 );
   
   GtkWidget *inner_hbox = gtk_hbox_new( FALSE, 0 );
   gtk_object_set_data( GTK_OBJECT( button ), "widget", inner_hbox );
   gtk_widget_show( inner_hbox );
   gtk_box_pack_start( GTK_BOX( vbox ), inner_hbox, FALSE, FALSE, 0 );

   group = gtk_radio_button_group( GTK_RADIO_BUTTON( button ));
   button = gtk_radio_button_new_with_label( group, "Last: " );
   gtk_object_set_data( GTK_OBJECT( inner_hbox ), "widget", button );
   gtk_widget_show( button );
   gtk_box_pack_start( GTK_BOX( inner_hbox ), button, FALSE, FALSE, 0 );
   gtk_signal_connect( GTK_OBJECT( button ), "pressed",
                       GTK_SIGNAL_FUNC( radio_buttons_callback ), data );
   gtk_object_set_data( GTK_OBJECT( button ), "what", ( gpointer )11 );

   GtkAdjustment *adjustment =
      ( GtkAdjustment *)gtk_adjustment_new( 1.0, 1.0, 9999.0,
                                            1.0, 1.0, 100.0 );
   GtkWidget *spin = gtk_spin_button_new( adjustment, 0, 0 );
   gtk_object_set_data( GTK_OBJECT( button ), "widget", spin );
   gtk_signal_connect( GTK_OBJECT( spin ), "changed",
                       GTK_SIGNAL_FUNC( spin_button_callback ), data );
   gtk_widget_show( spin );
   gtk_box_pack_start( GTK_BOX( inner_hbox ), spin, FALSE, FALSE, 10 );

   group = gtk_radio_button_group( GTK_RADIO_BUTTON( button ));
   button = gtk_radio_button_new_with_label( group,
                                              "None. "
                                              " Mark all new as seen." );
   gtk_object_set_data( GTK_OBJECT( spin ), "widget", button );
   gtk_widget_show( button );
   gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
   gtk_signal_connect( GTK_OBJECT( button ), "pressed",
                       GTK_SIGNAL_FUNC( radio_buttons_callback ), data );
   gtk_object_set_data( GTK_OBJECT( button ), "what", ( gpointer )12 );

   hbox = gtk_hbox_new( TRUE, 0 );
   gtk_widget_show( hbox );
   gtk_box_pack_start( GTK_BOX( top_vbox ), hbox, FALSE, FALSE, 0 );

   button = gtk_button_new_with_label( " OK " );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( transfer_callback ), data );
   gtk_object_set_data( GTK_OBJECT( button ), "ok", ( gpointer )1 );
   gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );

   button = gtk_button_new_with_label( " Cancel " );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( transfer_callback ), data );
   gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );

   gtk_widget_show( collections->transfer_window );
   gtk_grab_add( collections->transfer_window );

   return;
}
