#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "npstringarray.h"
#include "npfile.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::read_groups( char *server )
{
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", home );
   if ( file.openr( buffer ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: read_groups(): "
                "%s", file.get_error() );
      return 1;
   }

   char *line;
   do
      if (( line = file.get_string()) == NULL )
         break;
   while( strcmp( server, strtok( line, "\n" )));

   if ( line == NULL )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: read_groups(): "
                "no such server is listed in ~/.peruser4-newsrc: %s", server );
      file.close();
      return 1;
   }
   
   while(( line = file.get_string()) != NULL )
   {
      if ( !isspace( *line ))
         break;

      if ( array.add_item( strtok( line + strspn( line, " \t" ), ":" )))
      {
         snprintf( error_message, sizeof error_message, "NP_Tree: "
                   "read_groups(): %s", array.get_error() );
         file.close();
         return 1;
      }
   }

   file.close();

   return 0;
}
