#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

#include "help.C" 

void close_help_callback( GtkWidget *widget, gpointer data )
{
   gtk_widget_destroy( GTK_WIDGET( data ));
   return;
}

void help_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   GtkWidget *window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_container_border_width( GTK_CONTAINER( window ), 10 );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_help_callback ), window );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( close_help_callback ), window );
   gtk_window_set_title( GTK_WINDOW( window ),
                         "News Peruser Help" );
   gtk_widget_set_usize( window, 520, 350 );
   
   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_add( GTK_CONTAINER( window ), frame );

   GtkWidget *table = gtk_table_new( 40, 40, FALSE );
   gtk_widget_show( table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_table_set_row_spacing( GTK_TABLE( table ), 38, 10 );
   gtk_table_set_row_spacing( GTK_TABLE( table ), 1, 5 );
   
   GtkWidget *text_widget = gtk_text_new( NULL, NULL );
   gtk_widget_show( text_widget );
   gtk_text_set_editable( GTK_TEXT( text_widget ), FALSE );
   gtk_table_attach( GTK_TABLE( table ), text_widget, 0, 39, 3, 39,
                     GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 0 );

   GtkWidget *vscroll = gtk_vscrollbar_new( GTK_TEXT( text_widget )->vadj );
   gtk_table_attach( GTK_TABLE( table ), vscroll, 39, 40, 3, 39,
                     GTK_FILL, GTK_FILL, 0, 0 );
   gtk_widget_show( vscroll );

   gtk_widget_realize( text_widget );

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 0, 40, 39, 40 );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Close ",
                            "Close Window.", NULL, NULL,
                            GTK_SIGNAL_FUNC( close_help_callback ), window );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " About ",
                            "Send email to author or visit the News Peruser"
                            " website.", NULL, NULL,
                            GTK_SIGNAL_FUNC( about_button_callback ), 
                            collections );

   gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL, help_text,
                    strlen( help_text ));

   gtk_widget_show( window );

   return;
}

