#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

extern NP_Collections *collections_p;

void SIGCHLD_handler( int signo )
{
   pid_t pid;
   while(( pid = waitpid( -1, NULL, WNOHANG )) > 0 )
   {
      int total = collections_p->children.get_total();
      if ( total < 0 )
      {
         collections_p->children.print_error();
         return;
      }

      if ( total )
         for( int i = 0; i < total; ++i )
         {
            char *text = ( char *)collections_p->children[ i ];
            if ( text == NULL )
               continue;
            
            if ( pid == atoi( text ))
            {
               int result;
               while(( result = collections_p->children.remove_item( i ))
                     == 3 );
               if ( result )
                  collections_p->children.print_error();

               break;
            }
         }

      if ( pid == collections_p->launcher_pid )
         collections_p->launcher_pid = 0;

      if ( pid == collections_p->child_pid )
         collections_p->child_pid = 0;

      if ( pid == collections_p->compose_pid )
         collections_p->compose_pid = 0;
      
      if ( pid == collections_p->summary_pid )
      {
         collections_p->summary_pid = 0;
         if ( collections_p->summary_file != NULL )
         {
            fclose( collections_p->summary_file );
            collections_p->summary_file = NULL;
         }
         
         if ( collections_p->feedback_file != NULL )
         {
            fclose( collections_p->feedback_file );
            collections_p->feedback_file = NULL;
         }
      }
   }

   signal( SIGCHLD, SIGCHLD_handler );

   return;
}
