%{ /* make it look better in emacs: -*- mode: Makefile; -*- */
/* We need the Makefile mode in emacs to type \t (tab) characters */

/*
  Copyright (C) 1999, 2000 Florian Schintke
  Copyright (C) 1999       Martin Kammerhofer for the CGI feature

  This is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2, or (at your option) any later 
  version. 

  This is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
  for more details. 

  You should have received a copy of the GNU General Public License with 
  the pas2html source package as the 
  file COPYING. If not, write to the Free Software Foundation, Inc., 
  59 Temple Place - Suite 330, Boston, MA 
  02111-1307, USA. 
*/

/* 
 * We build a lexical analyzer that converts a Pascal source file to 
 * a beautifully highlighted HTML file now.
 */

#include "colors.h"
#include "mymain.h"

unsigned int oldstate = 0;

%}
%s COMMENT1
%s COMMENT2
%s STRING

id [a-z][a-z0123456789_]*
wsnl [\t \n]+
ws   [\t ]+

comment1nospecial [^&<>----\\\n*)]
comment2nospecial [^&<>----\n}]
stringnospecial   [^&<>----\\\n']

%%
	/* This characters have to be recoded everywhere
	 * because the WWW-browsers interpret them in their
	 * own (here not wanted) way.
	 */
"&"	{ MyStringOutput (yyout, "&amp;"); }
"<"	{ MyStringOutput (yyout, "&lt;"); }
">"	{ MyStringOutput (yyout, "&gt;"); }
	/* All character as latin1 greater than dec192 or hexBF */
""	{ MyStringOutput (yyout, "&Agrave;"); }
""	{ MyStringOutput (yyout, "&Aacute;"); }
""	{ MyStringOutput (yyout, "&Acirc;"); }
""	{ MyStringOutput (yyout, "&Atilde;"); }
""	{ MyStringOutput (yyout, "&Auml;"); } 
""	{ MyStringOutput (yyout, "&Aring;"); }
""	{ MyStringOutput (yyout, "&AElig;"); }
""	{ MyStringOutput (yyout, "&Ccedil;"); }
""	{ MyStringOutput (yyout, "&Egrave;"); }
""	{ MyStringOutput (yyout, "&Eacute;"); }
""	{ MyStringOutput (yyout, "&Ecirc;"); } 
""	{ MyStringOutput (yyout, "&Euml;"); }  
""	{ MyStringOutput (yyout, "&Igrave;"); }
""	{ MyStringOutput (yyout, "&Iacute;"); }
""	{ MyStringOutput (yyout, "&Icirc;"); } 
""	{ MyStringOutput (yyout, "&Iuml;"); }  
	/* ""	{ MyStringOutput (yyout, "", yytext); } */
""	{ MyStringOutput (yyout, "&Ntilde;"); }
""	{ MyStringOutput (yyout, "&Ograve;"); }
""	{ MyStringOutput (yyout, "&Oacute;"); }
""	{ MyStringOutput (yyout, "&Ocirc;"); } 
""	{ MyStringOutput (yyout, "&Otilde;"); }
""	{ MyStringOutput (yyout, "&Ouml;"); }  
	/* ""	{ MyStringOutput (yyout, "", yytext); } */
""	{ MyStringOutput (yyout, "&Oslash;"); }
""	{ MyStringOutput (yyout, "&Ugrave;"); }
""	{ MyStringOutput (yyout, "&Uacute;"); }
""	{ MyStringOutput (yyout, "&Ucirc;"); } 
""	{ MyStringOutput (yyout, "&Uuml;"); }  
""	{ MyStringOutput (yyout, "&Yacute;"); }
""	{ MyStringOutput (yyout, "&THORN;"); }
""	{ MyStringOutput (yyout, "&szlig;"); }
""	{ MyStringOutput (yyout, "&agrave;"); }
""	{ MyStringOutput (yyout, "&aacute;"); }
""	{ MyStringOutput (yyout, "&acirc;"); } 
""	{ MyStringOutput (yyout, "&atilde;"); }  
""	{ MyStringOutput (yyout, "&auml;"); }
""	{ MyStringOutput (yyout, "&aring;"); }
""	{ MyStringOutput (yyout, "&aelig;"); }
""	{ MyStringOutput (yyout, "&ccedil;"); }
""	{ MyStringOutput (yyout, "&egrave;"); }
""	{ MyStringOutput (yyout, "&eacute;"); }
""	{ MyStringOutput (yyout, "&ecirc;"); } 
""	{ MyStringOutput (yyout, "&euml;"); }  
""	{ MyStringOutput (yyout, "&igrave;"); }
""	{ MyStringOutput (yyout, "&iacute;"); }
""	{ MyStringOutput (yyout, "&icirc;"); } 
""	{ MyStringOutput (yyout, "&iuml;"); }  
""	{ MyStringOutput (yyout, "&eth;"); }
""	{ MyStringOutput (yyout, "&ntilde;"); }
""	{ MyStringOutput (yyout, "&ograve;"); }
""	{ MyStringOutput (yyout, "&oacute;"); }
""	{ MyStringOutput (yyout, "&ocirc;"); } 
""	{ MyStringOutput (yyout, "&otilde;"); }  
""	{ MyStringOutput (yyout, "&ouml;"); }
	/* ""	{ MyStringOutput (yyout, "", yytext); } */
""	{ MyStringOutput (yyout, "&oslash;"); }
""	{ MyStringOutput (yyout, "&ugrave;"); }
""	{ MyStringOutput (yyout, "&uacute;"); }
""	{ MyStringOutput (yyout, "&ucirc;"); } 
""	{ MyStringOutput (yyout, "&uuml;"); }  
""	{ MyStringOutput (yyout, "&yacute;"); }
""	{ MyStringOutput (yyout, "&thorn;"); }
""	{ MyStringOutput (yyout, "&yuml;"); }

<STRING>\'	{ 
		  BEGIN 0;
		  /* Close the string font */
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		}
<STRING>\n	{
		  MyStringOutput(yyout, yytext);
		}
<STRING>{stringnospecial}+	{ MyStringOutput(yyout, yytext); }

<COMMENT1>("(*"|"{")	{ MyStringOutput(yyout, yytext); }
<COMMENT1>\n	{
		  MyStringOutput(yyout, yytext);
		}
<COMMENT1>{comment1nospecial}+	{ MyStringOutput(yyout, yytext); }
<COMMENT1>"*"/[^)]	{ MyStringOutput(yyout, yytext); }
<COMMENT1>"*)"	{
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NO_CHANGE);
		  BEGIN 0; 
		}

<COMMENT2>{comment2nospecial}* { MyStringOutput(yyout, yytext); }
<COMMENT2>"}"	{ 
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NO_CHANGE);
		  BEGIN 0; 
		}
\'	{
	  BEGIN STRING;
	  ChangeFontTo(yyout, stringcolor, NORMAL);
	  MyStringOutput(yyout, yytext);
	}
"(*"	{
	  BEGIN COMMENT1;
	  ChangeFontTo(yyout, commentcolor, NORMAL);
	  MyStringOutput(yyout, yytext);
	}
"{"	{
	  BEGIN COMMENT2;
	  ChangeFontTo(yyout, commentcolor, NORMAL);
	  MyStringOutput(yyout, yytext);
	}


"var"|"const"|"type"	{
		  ChangeFontTo(yyout, definelinecolor, BOLD);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		}
"begin"|"end"|"program"	{
		  ChangeFontTo(yyout, keywordcolor, BOLD);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		}

("procedure"|"function"){wsnl}{id}	{
		  ChangeFontTo(yyout, keywordcolor, BOLD);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		}		  
"while"|"for"|"do"|"repeat"|"until"|"case"|"to"|"of"|"if"|"else"|"not"|"then"|"and"|"or"	{
		  ChangeFontTo(yyout, keywordcolor, NORMAL);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		}

{ws}		{ 
		  MyStringOutput(yyout, yytext);
		  /* let whitespaces like they are */
		}

[a-z_][a-z_0123456789]*	{
		  MyStringOutput(yyout, yytext);
		}

.		{ 
		  MyStringOutput(yyout, yytext);
		}
\n		{ 
		  MyStringOutput(yyout, yytext);
		}
%%

void 
StartNewYylex(FILE * in, FILE * out)
{
  BEGIN 0;
  oldstate              = 0;
  yyin                  = in;
  yyout                 = out;
  config.lineNumber     = 1;
  config.needLabel      = 1;
  config.currentColor   = NULL;
  config.currentWeight  = NORMAL;
  config.suppressOutput = config.indexOnly;

  yylex();
}

int
main(int argc, char *argv[])
{
  return MyMain(argc, argv);
  /* unreachable, but suppresses compiler warning. */
  yyunput(0, NULL);
}
