/** @file
	Parser: @b Methoded class decl.

	Copyright (c) 2001-2009 ArtLebedev Group (http://www.artlebedev.com)
	Author: Alexandr Petrosian <paf@design.ru> (http://paf.design.ru)
*/

#ifndef CLASSES_H
#define CLASSES_H

static const char * const IDENT_CLASSES_H="$Date: 2009-08-08 13:30:20 $";

// include

#include "pa_vstateless_class.h"
#include "pa_array.h"

/**	Pure virtual base for configurable Methoded descendants
	@see Methoded_array
*/
class Methoded: public VStateless_class {
public: // Methoded

	/** should Methoded_array::register_directly_used register this class in
		Request::classes() or not. 
		if not - global variable with Methoded descendant 
		is used in VStateless_class parameter
	*/
	virtual bool used_directly() =0;
	/// use this method to read parameters from root "auto.p"; access r.main_class
	virtual void configure_admin(Request& ) {}
	/// use this method to read parameters from 'MAIN' class; access r.main_class
	virtual void configure_user(Request& ) {}
	/// use it to construct static variables. check some static so that would be only ONCE!
	virtual void construct_statics() {}

public: // usage

	Methoded(const char* aname, VStateless_class* abase=0): 
		VStateless_class(new String(aname), abase) {
	}

	void register_directly_used(Request& r);

};

/// all Methoded registered here in autogenerated classes.C
class Methoded_array: public Array<Methoded*> {
public:
	Methoded_array();

public: // Methoded for_each-es
	/// @see Methoded::configure_admin
	void configure_admin(Request& r);
	/// @see Methoded::configure_user
	void configure_user(Request& r);
	/// @see Methoded::register_directly_used
	void register_directly_used(Request& r);
};

// globals

Methoded_array& methoded_array();

// defines

#define DECLARE_CLASS_VAR(name, self, base) \
	Methoded* name##_class=self; \
	Methoded* name##_base_class=base

#endif
