/*
**  LocalFolder.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_LocalFolder
#define _Pantomime_H_LocalFolder

#include <Pantomime/Folder.h>

#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSString.h>

#include <stdio.h>

@class LocalFolderCacheManager;
@class Part;

@interface LocalFolder : Folder
{
  NSDictionary *fileAttributes;
  NSString *path, *mailFilename;
  
  int fd, folderType;
  FILE *stream;
}

- (id) initWithPathToFile: (NSString *) thePath;

- (void) parse;

- (NSData *) unfoldLinesStartingWith: (char *) firstLine
                          fileStream: (FILE *) theStream;

//
// access / mutation methods
//
- (int) fd;
- (void) setFD: (int) theFD;

- (NSString *) path;
- (void) setPath: (NSString *) thePath;

- (FILE *) stream;
- (void) setStream: (FILE *) theStream;

- (NSString *) mailFilename;
- (void) setMailFilename: (NSString *) theFilename;

- (NSDictionary *) fileAttributes;
- (void) setFileAttributes: (NSDictionary *) theAttributes;

- (int) folderType;
- (void) setFolderType: (int) theType;

@end


//
// Private methods
//
@interface LocalFolder (Private)

- (FILE *) _openAndLockFolder: (NSString *) thePath;

- (int) _parseMailFile: (NSString *) theFile 
            fileStream: (FILE *) aStream 
                 index: (int) theIndex;

- (BOOL) _parseMaildir: (NSString *) theDir;

- (NSArray *) _expungeMBOX: (BOOL) returnDeletedMessages;
- (NSArray *) _expungeMAILDIR: (BOOL) returnDeletedMessages;

- (BOOL) _findInPart: (Part *) thePart
              string: (NSString *) theString
                mask: (int) theMask
             options: (int) theOptions;

@end

#endif // _Pantomime_H_LocalFolder
