/*
**  Folder.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_Folder
#define _Pantomime_H_Folder

#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

@class Container;
@class Flags;
@class Message;
@class Store;

@interface Folder : NSObject
{
  @public
    NSMutableArray *allMessages;

  @protected
    NSMutableArray *allVisibleMessages, *allContainers, *allVisibleContainers;
    id cacheManager;
    NSString *name;
    
    Store *store;
    
    BOOL showDeleted;
    BOOL showRead;

    int mode;
}

- (id) initWithName: (NSString *) theName;

- (NSString *) name;
- (void) setName: (NSString *) theName;

- (void) appendMessage: (Message *) theMessage;

- (void) appendMessageFromRawSource: (NSData *) theData
                              flags: (Flags *) theFlags;

- (NSArray *) allMessages;
- (void) setMessages: (NSArray *) theMessages;

- (Message *) messageAtIndex: (int) theIndex;

- (int) count;

- (void) close;

- (NSArray *) expunge: (BOOL) returnDeletedMessages;

- (Store *) store;
- (void) setStore: (Store *) theStore;

- (void) removeMessage: (Message *) theMessage;

- (BOOL) showDeleted;
- (void) setShowDeleted: (BOOL) theBOOL;

- (BOOL) showRead;
- (void) setShowRead: (BOOL) theBOOL;

- (int) numberOfDeletedMessages;
- (int) numberOfUnreadMessages;

- (long) size;

- (void) updateCache;

- (NSArray *) allContainers;

- (void) thread;

- (NSArray *) search: (NSString *) theString
                mask: (int) theMask
             options: (int) theOptions;

- (id) cacheManager;
- (void) setCacheManager: (id) theCacheManager;

- (int) mode;

- (void) setFlags: (Flags *) theFlags
         messages: (NSArray *) theMessages;


@end

#endif // _Pantomime_H_Folder
