//
// C++ Implementation: selectedfacetsmatcher
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <tagcoll/Tag.h>
#include <tagcoll/TagSet.h>	// for FacetSet

#include "selectedfacetsmatcher.h"

namespace NDebtags 
{

SelectedFacetsMatcher::SelectedFacetsMatcher(const set<string>& facetNames)
 : FacetMatcher(),
 	_facetNames(facetNames)
{
}


SelectedFacetsMatcher::~SelectedFacetsMatcher()
{
}

bool SelectedFacetsMatcher::match(const Tagcoll::Facet& facet) const throw ()
{
	set<string>::const_iterator it = _facetNames.find(facet.name());
	return it != _facetNames.end();
}

HiddenFacetsMatcher::HiddenFacetsMatcher(const set<string>& hiddenFacetNames)
 : FacetMatcher(),
 	_hiddenFacetNames(hiddenFacetNames)
{
}


HiddenFacetsMatcher::HiddenFacetsMatcher(const Tagcoll::FacetSet& hiddenFacets)
{
	for( Tagcoll::FacetSet::const_iterator it = hiddenFacets.begin(); it != hiddenFacets.end(); ++it)
		_hiddenFacetNames.insert(it->name());
}


HiddenFacetsMatcher::~HiddenFacetsMatcher()
{
}

bool HiddenFacetsMatcher::match(const Tagcoll::Facet& facet) const throw ()
{
	set<string>::const_iterator it = _hiddenFacetNames.find(facet.name());
	return it == _hiddenFacetNames.end();
}


};
