//
// C++ Interface: pluginlistviewitem
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __PLUGINLISTITEM_H_2004_08_13
#define __PLUGINLISTITEM_H_2004_08_13

#include <qlistview.h>

#include "pluginmanager.h"

namespace NPlugin 
{

class PluginContainer;

/** This item is used to keep track of the information about the plugin.
  * @author Benjamin Mesing
  */
class PluginListItem : public QObject, public QCheckListItem
{
	Q_OBJECT
public:
	PluginListItem(QListView* parent, const PluginManager::PluginData& pd);
	~PluginListItem();
	void setDynamicData(void* libraryHandle, PluginContainer* pPlugin);
	const PluginManager::PluginData& pluginData()	{ return  _pluginData; }
signals:
	/** This is emitted whenever the state is toggled. */
	void toggled(PluginListItem* pSrc, bool state);

protected:
	/** Called whenever the state of the toggle button changed. */
	virtual void stateChange(bool state);
private:
	/** This holds the data about the plugin this item is connected to. */
	PluginManager::PluginData _pluginData;
};


};

#endif	//  __PLUGINLISTITEM_H_2004_08_13
