#!/usr/bin/env python

from docutils.core import publish_string, publish_parts
import base64
import os
import pudge.browser
import re
import sys
import textwrap
import time
from twill.commands import *
from twill import get_browser
import nose

div = '\n----\n'

def section(doc, name):
    m = re.search(r'(%s\n%s.*?)\n[^\n-]{3,}\n-{3,}\n' %
                  (name, '-' * len(name)), doc, re.DOTALL)
    if m:
        return m.groups()[0]
    raise Exception('Section %s not found' % name)

def wikirst(doc):
    #
    # module -> page links (will be subbed into each page's string)
    #
    modlinks = { r'\bnose\.plugins\b': 'WritingPlugins'
             
             
                 }

    # not working at all..
    #for k in modlinks:
    #    doc = re.sub(k, '`' + modlinks[k] + '`:trac', doc)

    doc = '`This page is autogenerated. Please add comments only ' \
        'beneath the horizontal rule at the bottom of the page. ' \
        'Changes above that line will be lost when the page is '\
        'regenerated.`\n\n' + doc
    
    return '{{{\n#!rst\n%s\n}}}\n' % doc

def plugin_interface():
    """use pudge browser to generate interface docs
    from nose.plugins.base.PluginInterface
    """
    b = pudge.browser.Browser(['nose.plugins.base'], None)
    m = b.modules()[0]
    intf = list([ c for c in m.classes() if c.name ==
                  'IPluginInterface'])[0]
    doc = '{{{\n#!rst\n' + intf.doc() + '\n}}}\n'
    methods = [ m for m in intf.routines() if not m.name.startswith('_') ]
    methods.sort(lambda a, b: cmp(a.name, b.name))
    doc = doc + '{{{\n#!html\n'
    for m in methods:
        doc = doc + '<b>' + m.name + m.formatargs() + '</b><br />'
        doc = doc + m.doc(html=1)
    doc = doc + '\n}}}\n'
    return doc

def example_plugin():
    # FIXME dump whole example plugin code from setup.py and plug.py
    # into python source sections
    root = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                        '..'))
    exp = os.path.join(root, 'examples', 'plugin')
    setup = file(os.path.join(exp, 'setup.py'), 'r').read()
    plug = file(os.path.join(exp, 'plug.py'), 'r').read()

    wik = "'''%s:'''\n{{{\n#!python\n%s\n}}}\n"
    return wik % ('setup.py', setup) + wik % ('plug.py', plug)

def mkwiki(url, realm, user, passwd):
    #
    # Pages to publish and the docstring(s) to load for that page
    #

    pages = {  #'SandBox': wikirst(section(nose.__doc__, 'Writing tests'))
        'WritingTests': wikirst(section(nose.__doc__, 'Writing tests')),
        'NoseFeatures': wikirst(section(nose.__doc__, 'Features')),
        'WritingPlugins': wikirst(nose.plugins.__doc__),
        'PluginInterface': plugin_interface(),
        # FIXME finish example plugin doc... add some explanation
        'ExamplePlugin': example_plugin(),
        
        'NosetestsUsage': '\n{{{\n' +
        nose.configure(help=True).replace('mkwiki.py', 'nosetests') +
        '\n}}}\n'
        }
    
    w = TracWiki(url, realm, user, passwd)

    for page, doc in pages.items():
        print "====== %s ======" % page
        w.update_docs(page, doc)
        print "====== %s ======" % page

class TracWiki(object):
    doc_re = re.compile(r'(.*?)' + div, re.DOTALL)
    
    def __init__(self, url, realm, user, passwd):
        self.url = url
        self.b = get_browser()
        go(url)
        add_auth(realm, url, user, passwd)
        go('/login')
        
    def get_page(self, page):
        go('/wiki/%s?edit=yes' % page)
        self.edit = self.b.get_form('edit')
        return self.edit.get_value('text')

    def set_docs(self, page_src, docs):
        wikified = docs + div
        if self.doc_re.search(page_src):
            print "! Updating doc section"
            new_src = self.doc_re.sub(wikified, page_src, 1)
        else:
            print "! Adding new doc section"
            new_src = wikified + page_src
        if new_src == page_src:
            print "! No changes"
            return
        fv(re.compile('edit'), 'text', new_src)
        submit('save')

    def update_docs(self, page, doc):
        current = self.get_page(page)
        self.set_docs(current, doc)

        
def main():

    try:
        url = sys.argv[1]
    except IndexError:
        url = 'https://nose.python-hosting.com'
    realm = os.environ.get('NOSE_WIKI_REALM')
    user = os.environ.get('NOSE_WIKI_USER')
    passwd = os.environ.get('NOSE_WIKI_PASSWD')
    
    mkwiki(url, realm, user, passwd)

if __name__ == '__main__':
    main()
