# {%= name %} {%= badge("fury") %}

> {%= description %}

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
var unset = require('{%= name %}');

var obj = {a: {b: {c: 'd', e: 'f'}}};
unset(obj, 'a.b.c');
console.log(obj);
//=> {a: {b: {e: 'f'}}};
```

## Examples

### Updates the object when a property is deleted

```js
var obj = {a: 'b'};
unset(obj, 'a');
console.log(obj);
//=> {}
```

### Returns true when a property is deleted

```js
unset({a: 'b'}, 'a') // true
```

### Returns `true` when a property does not exist

This is consistent with `delete` behavior in that it does not
throw when a property does not exist. 

```js
unset({a: {b: {c: 'd'}}}, 'd') // true
```

### delete nested values

```js
var one = {a: {b: {c: 'd'}}};
unset(one, 'a.b');
console.log(one);
//=> {a: {}}

var two = {a: {b: {c: 'd'}}};
unset(two, 'a.b.c');
console.log(two);
//=> {a: {b: {}}}

var three = {a: {b: {c: 'd', e: 'f'}}};
unset(three, 'a.b.c');
console.log(three);
//=> {a: {b: {e: 'f'}}}
```

### throws on invalid args

```js
unset();
// 'expected an object.'
```

## Related projects
{%= related(verb.related.list, {remove: name}) %}  

## Running tests
{%= include("tests") %}

## Contributing
{%= include("contributing") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
