(* $Id: netdate.mli,v 1.1 2001/08/30 19:50:42 gerd Exp $
 * ----------------------------------------------------------------------
 *
 *)


(* Support for common date/time formats in the net *)

(* mk_*: convert the time (seconds since the epoch) to a date string.
 * The time zone is always GMT.
 *)

val mk_mail_date : float -> string
  (* "Sun, 06 Nov 1994 08:49:37 GMT".
   * Conforms to RFC 1123 which updates RFC 822
   *)

val mk_usenet_date : float -> string
  (* "Sunday, 06-Nov-94 08:49:37 GMT".
   * Conforms to RFC 1036 which obsoletes RFC 850. 
   * Note that this format has only two digits for the year.
   *)

(* ======================================================================
 * History:
 * 
 * $Log: netdate.mli,v $
 * Revision 1.1  2001/08/30 19:50:42  gerd
 * 	Initial revision.
 *
 * 
 *)
