#ifndef _UTIL_H
#define _UTIL_H

/* utils.h
  
   Data structures and function declarations for facitilities
   provided in utils.c

   Copyright (C) 2007, 2008, 2009, 2010 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdint.h>
#include <sys/time.h> /* For struct timeval */
#include <dnet.h>

extern void dump(const unsigned char *data, unsigned len);
extern void error(const char *, ...);
extern void warn(const char *, ...);
extern void debug(const char *fmt, ...);
extern unsigned short in_checksum(void *data, int len);
extern char *make_prefix(int level);
extern char *mac_to_ascii(eth_addr_t *);
extern int format_ethernet_addr(const char *, uint8_t [ETH_ADDR_LEN]);
extern int parse_mac_addr(const char *, struct addr *);
extern char *copy_argv(char **);
extern char *ipaddr2str(ip_addr_t);
extern char *ip6addr2str(ip6_addr_t);
extern ip_addr_t random_ip(ip_addr_t, ip_addr_t);
extern int random_int(int a, int b);
extern void random_block(uint8_t *, size_t);
extern const char *ts2str(register const struct timeval *);
extern int32_t gmt2local(time_t);
extern int compare_integers(const void *, const void *);

#endif /* _UTIL_H */
