!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  time.S
!* Purpose: Various time related functions
!* Entries: _set_timeout, _chk_timeout, _get_ticks
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! BSS segment:
!
	.bss

	.lcomm	endval,4		! counter tick end value


!
!**************************************************************************
!
! Start code segment.
!
	.text

	public	_set_timeout		! define entry points
	public	_chk_timeout
	public	_get_ticks

	extrn	_pktpoll


!
!**************************************************************************
!
! Get current number of timer ticks.
! Input:  none
! Output: DX:AX  -  number of timer ticks
!
_get_ticks:

	xor	ah,ah
	int	$1A			! get current timer count from BIOS
#ifdef OPT386
	mov	ax,cx
	shl	eax,#16			! prepare return value
	mov	ax,dx
#else
	mov	ax,dx			! prepare return values
	mov	dx,cx
#endif
	ret



!
!**************************************************************************
!
! Set timer tick end value for timeout.
! Input:  1. arg  -  number of timer ticks until timeout
! Output: none
!
_set_timeout:

	penter
#ifdef OPT386
	call	_get_ticks
	getlarg	(ebx,0,word)
	add	eax,ebx
	mov	[endval],eax
#else
	xor	ah,ah
	int	$1A			! get current timer count from BIOS
	getcarg	(bx,0)			! get numer of ticks to sleep
	add	dx,bx
	adc	cx,#0			! compute end count
	mov	word ptr [endval+0],dx
	mov	word ptr [endval+2],cx
#endif
	pleave
	ret


!
!**************************************************************************
!
! Check if timer reached timeout value.
! Input:  none
! Output: non-zero, if timeout value reached
!
_chk_timeout:

	call	near _pktpoll		! care for polling events
#ifdef OPT386
	call	_get_ticks		! compare current tick count with
	cmp	eax,[endval]		! end count
	cmc
	rcl	ax,#1			! prepare return value
	and	ax,#$0001
#else
	xor	ah,ah
	int	$1A			! get current time
	xor	ax,ax
	cmp	cx,word ptr [endval+2]	! compare current tick count with
	jb	chkt2			! end count
	ja	chkt1
	cmp	dx,word ptr [endval+0]
	jb	chkt2
chkt1:	inc	ax
#endif
chkt2:	ret


!
!**************************************************************************
!
	end

