#TRUSTED 99dc4d1acc561c261398c96ccfeb5f64075a3bd81120751108fbffbaa7c0120360500c34230f0357fdfaf2ef6f938e7d270d30563b14d29830343e255d8109fb8c896fa544ef63b2f7495bd21c4491adc7daaa0e4d1f43575d9051892887309bcb324dcd12340c9d36f78b3f1a66d1df552e93c79beee342cfa9b9d0e72f39da7915274dfea6490a84ce3fdc59915c87e8410ecd4151afb15c93f111d6ae9767b3851ffd77a41cbc3d0474e3e78faaaa11a9c217226a3746a5e5183a4a5ec82b40c82dbf3f0072be235db5865d29c1e8a1aabc6965741ad2f3e6ae8f993caf68661b15e148a12409a724ce23c9a35e983df80d0243716c879695b7565b801bcbf90cd26957515c10ce3168c050fc08816dc3a448e03c43b196c9ab5847e71b7bf2b581d25a6179e9163422d46bf04ed7b728de83a7726b61568c73cdc0561d2e35829a5af43ec6c6991ccaab48a122ec3ec990631712e66b29c2e4a1a0102d90c5402fcf97efbac9870433f48b824051205ab8c747a7f372a1185b2fe28210c66b7b04833ea044faa57ac1bafc64fa6f11310f4bcc65d962752ea7e19db13865aa12af37d19096fcefd35ea0c1bd80b0e174a2db8ca8e4de7402ca3b521c915db6504cdf81b522f6dd9d9cb73b21cf01aaa0603edc88f38e5579cb699161823a479d0a86077e32211b5078f1714b48a904f76b6780a1850b18400397fb788815
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15881);
 script_version ("1.1");
 name["english"] = "Hydra: POP3";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find POP3 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force POP3 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/pop3", 110);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/pop3");
if (! port) port = 110;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "pop3";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following POP3 accounts:\n' + report);
