#TRUSTED 30ec82b4cc9cbf7c4a2dac0dbb2e73dfb32a4f1d18db6a157325d189b14d6454f355e6cdd222fbdde52cb5f27e39a59c3f910197eeb07acd619a4de3d1d05bcbb132a92771091fedb3c523c69be881cf14ab616ea86f61be931b99cde7aa52232649b965786029c77a5e08947f41aea37df7c2e9a7b86d44f0944c3a7f5c1b6c4bec5efcbfb9c609b4315b182a745f3fa0cf199d9a9d5506695bc8221c0f001edd3ae6208cf3a86dff8c9ad613c5d7058f8a06403e8c72fa62a1ac93edb6852f65122f4fc52ab4637a5af0990c05ef5822c1394ed59f64c19176165c728089661880d12c9daf56612941baebec1eca54c39dcc0c7454ff1ed84dba77fd3de025541ac0578135e800d6af3241888ca3277d336fe49e9303389568679d715969e2165beae1a1dc92532692ccbb148ae701ce40a63175e2174b9a1b87fe6773935eb66f56400326b70987403da03d2e48754fed0fdf406e29053c08dda478593613424924269fa433904cf8fb9bbe7bb04190fe548c94cce2d28af53a2a1e7a1f8819887df597d138a5c4c0398773c52ba37bdf58240ce07b27bfdebcd2102132c1c16ae01f014aa0d167ca64e781c5b88283256e1a75b8f206c127788234fa6e20395bc3712cda4fa4db023570e95c1f235a1fdcacbe5260eb2781efbc90229278eaa2616834ab0adb3cb93456a3b714b60d0fbac386736bbf942505b2a9571bb0
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15879);
 script_version ("1.1");
 name["english"] = "Hydra: NNTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find NNTP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force NNTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/nntp", 119);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "find_service_3digits.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/nntp");
if (! port) port = 119;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "nntp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/nntp/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following NNTP accounts:\n' + report);
