#TRUSTED 4319f5126c1731173c93a3a808b2e68a4e09fd79a20a633e475c3b86c3b2dba48b0079e7936d1a91ad865640e55b7ae75f32a103b7fb5e0fa16787237d2df067730179f535aedae6500a14f5dc94c6eb2c65fea09e2df123f87fe729adf86fa7ad50398c2d3515a97eaf3300a5ae760c301e4528d18c27992a8c6350f0ba1b256752b571f888569f8d7c99f5e39b1b42c013bc0ddbc4abd0309e10bfdfefd4cfda411fa854d01323d717f8bfcb49f75f221495979ac8950a74b62313b76f708751dbcf7500144bf4ebf70a111b4b3a10732f7d51dc6d52546886a643d2cf60fb099c433d08506fa05133021a087acf9564a7bc2fd22e6eaa3cc503e397e6ea4652d24c01f2b1ce5e65d8d0fde568880db5bdc90740616c4af729a7c7b1d531af2f2a849653e4a53154e8f512821ef7023b7027a96511d2b7a61269eeaa2446a53692dabc2f97e54e5dcae1e2a3e55db602f51835485aa74b1f1927e5e228a6ff4fdc065249b32006cb4366d6a1694862537024a0367ad0f266dbba0c7ea5058e010481ecfe12c4b7579e26dafd9c272643868958053785454a485de123537e62bc3f740c9c27738c18150e7cbb0081dc465edc2b61dfd613c730ebc78fc621a5fd98133cf6808e92285077732fa9a811541a9472375247f5ae416d1236ed1873d51ae56f54abad7f1123d63039c3fa01dbfaeffcad8284311483495b3b6042e1
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15876);
 script_version ("1.1");
 name["english"] = "Hydra: IMAP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find IMAP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force IMAP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/imap", 143);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/imap");
if (! port) port = 143;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "imap";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/imap/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following IMAP accounts:\n' + report);
