#TRUSTED 81c77876168975a0532bee33034061cdf29aaa8164314a71f1ccf0d21e28ecd605b1a788e47d4b8d2508eb3e8435072dc4dcb538b08393ad732da45b07cb277dddac7fe2f4d250015c4d599d9d59d718716dbd733a10c56d850e294c26184cc65370db5c1e7013e0dd37709779a1d8d9e9759b8c6b9f23ed40084738924ec9742467c282bcd3a7e2953603ab398267a73989591ef1fa422beb1a91787412b52e5184c4b7fbc6427d6be8c15080305ed66e6fa2db3339facc07d44c5b1a96dde8e6bbb0f5651d0f8004204b612bcb5e1f703bf8af4ff46b17d36ee62c806e180f05b52321d76bab3966f11c43cd14e28cc0cd3e3983e875d509f77c6b58da8b216985fbeeb6846de2a2fb21b33ae9e5b43574d16cfccd986be8b78900addf1c47f357a79972a9f619b01de8a0b976d9bdaaf6e10248098c245c660bf8e54551cb90812ad8e431d0f61fa7bdc9ffdbe0e3d8c4e75ee1a91dce3db4b1bc2ee051b3459ce524753ce3b3db5f20f95619f73f5b6eff5616996835f36c2dffb26ab43c5625d8422fa2e661b603ae4d0ebe975dd76d0433df0db8ab7f3de0f6bc9306baef6a6e64b88f944f591b86ee8d1df3e1e0d1a9597afcf0da71dc73041614e254e954662ea588cc0cc7b4fd7deffe69d2bab0c9e62fcc9a0dada0096e5dd94493cca1654b97e818127382d7c87da18da6decd490896cfc0be28eb5301207b9d40
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15874);
 script_version ("1.1");
 name["english"] = "Hydra: HTTP proxy";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP proxy accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP proxy authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Web site (optional) :", value: "", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/http_proxy", 3128);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/http_proxy");
if (! port) port = 3128;
if (! get_port_state(port)) exit(0);

# www.suse.com by default
opt = script_get_preference("Site (optional) :");
if (!opt) site = 'http://www.suse.com/';
else if (opt !~ '^(http|ftp)://') site = strcat('http://', opt);
else site = opt;
host = ereg_replace(string: site, pattern: '^(ftp|http://)([^/]+@)?([^/]+)/.*',
	replace: "\3");
if (host == site)
 req = 'GET '+site+' HTTP/1.0\r\n\r\n';
else
 req = 'GET '+site+' HTTP/1.1\r\nHost: '+host+'\r\n\r\n';
s = open_sock_tcp(port);
if (!s) exit(0);
send(socket: s, data: req);
r = recv_line(socket: s, length: 1024);
close(s);
if (r =~ "^HTTP/1\.[01] +[234]0[0-9] ") exit(0);	# Proxy is not protected

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "http-proxy";

if (opt) argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http-proxy/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the HTTP proxy:\n' + report);
