#TRUSTED 7db22e6593681bcac5c55c3356e6a572abaaa856a1945068e73f1725fbfc6a56614484c03d62de10e60d37852534e14d353cf63daa697935d3940e0be297bcb0fd91cc39fc65ee8e6f7f41285c03ee142f2e859f4b94e3cc6a9eb479101186b2fc0b1476402a5b04c42bbda64122f0c287af52a1d92516a37bf8ac6a8b52aea9d16149462a9611ab6f3104f31cabb27d926d252b05c0e42e0afec0118ffcb77a0e9dc59edf40be2473fe7375035700f86deba4fcf5601fdf640687851eeac21dcb02259f2f87701deab6bd4efb7ca8229482b61360c4dc8f55c4dc6bc655e42103d32a834565ad3e0f5838ed99f8371e488b1a6ff055e6df775a23e5fca0fdf435cfdaddec4a714bbc8eac02d1f5151621bdff8e3f3e30ff1208905b53f5af8cb3c900e0043df99174802698bb14ec523dbaf33e1236e344d3f19f8d4c61592f29e5a1b5363aaf2859b0ec6472dff4cf7612a38bb3be4638a052b2109fc1962c6a8a50cf96d6ec024fd45b7da4eb059959aee2586005872e5a28b719b598a5e8f50ffc9d311956e67fbc01ea8eeb99c0a44bd317155c0cf734116bd82cd1825bd4ad92f210ea65ef392e014d7b5b0457f810df3ac54ef2a7faea71cb906a5d995e9e55f88d561ec2b234217ff8ca963cae8b8b0efc762af1db5bf677f6f4954d6a68845c4d46e44fc9a0764b5498d6de91f967df3d7059dd14300eb5d851f6f7
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15880);
 script_version ("1.3");
 name["english"] = "Hydra: PCNFS";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find PCNFS accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force PCNFS authentication with Hydra";
 script_summary(english:summary["english"]);
 script_timeout(0);
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_udp_ports(640);
 script_dependencies("hydra_options.nasl", "external_svc_ident.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/udp/pcnfs");
if (! port) exit(0);	# port = 640;
if (! get_udp_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "pcnfs";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*)? password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/pcnfs/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following PC-NFS accounts:\n' + report);
