#TRUSTED 60c29ef539c2d3767d0fffb347973b80d88c9f512c2b9b5a7306d28be1da73f5cd6aad9bffad73e693d6c9e08b4f748bf413c76d3944ecb83e6cd63faae86e5f13f1655ad3c7963448ba370057b6e5503c71661a582dd90ed83b3cb5ef05b003a601668a334862144fa76fa79f0b474d7cc535e96c21e02cabfce7ea1fea399822c53282c768d8e4f9ca59800c91ead39b4a96c24f6f53265f5668ec980dcf76794648a07573ef30834b6c2c5f6f0c1a85a59135b678b79d13e22fa76ab1e3f7f6398be4f4a6e1a0360a2f4ce538264a4a518038c9e06d71633820414885f320ece3140b6461365ef28b7e26172a8f42d1c2bc2674a2b9e255c7e89522712aaa149661441fd57960394ec07751e7cc8587dd18ba0674b6a69ba1339a19be9613a6aea40193933a523d1a127e71d4725f69887b6b1aa84861d11b3a79673cdf45069e0bf1d6175a5d5074b5efdd2ce01f6a112851c454ce636e3b2b49f0294c792a4dc42030911ac0b7007518b3dff7c89bc5aa268c3db7528bb0a58eaf58170b3bc920181248d38e509266f5de64fe4dd004ff7e1e1ecd012345ebdc91f54ab29b4f6b4c34afe03bc70a759e228366faf4a35a10063325253f329006fca349c03ee052df803ba0fc7bf057df25f091c623f94b139646668ab28cde601745136a487597573a28ccd910fa1bc505c881d575818f1b94e6f7d3092e66e1310be466
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15877);
 script_version ("1.3");
 name["english"] = "Hydra: LDAP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find LDAP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force LDAP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_add_preference(name: "DN : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ldap", 389);
 # find_service does not detect LDAP yet, so we rely upon amap
 # However find_services will detect the SSL layer for LDAPS
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl", "external_svc_ident.nasl", "ldap_detect.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
 throrough = get_kb_item("global_settings/thorough_tests");
 if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/ldap");
if (! port) exit(0);
if (! get_port_state(port)) exit(0);

# We should check that the server is up & running

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

dn = script_get_preference("DN : ");
if (! dn) exit(0);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ldap";
argv[i++] = dn;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/ldap/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the LDAP server:\n' + report);
