#TRUSTED 1564acbb8368c68f35f1d74cd423b003de9120b15716a0bf0a4a801b5e9782492fb4c5095feab9d993de4a856892961d57b27c7e1571d3c6cde80db0cedffab07a8a7140d3428f66ab6fa97f8c5f6d24170d3900175663aba3c0b3c2311cd6111af38e9c4b0d88d3d645a8edfb03ba9acf992e374bb1d7c6e7db2011f82e4834cc6e39000a29c4eeec8f19af11fcf560c9ed807cc2713f9ba0951979c1b7e5bcc45ff91626ad669e6b4e2c6b5cdddf0eac1efc714a024f41222d77f8f32d87f759ac765134fd950aae68278472824585ff61a815cd52085fd54d41f99a51f2626e72a09c14e498df65ceb89c7109a021a28b1f4bdb18d279a9029b7d0e1b213a34cb869f100c7a15d54621bc657135cb2698b2f3eece3d6d99d10574928ecaf9c22eb7795b785cf3b1d89da0dc82717067da9e524fcb466770445b55125e2e394197de52069885344e59ee1f82071e0418e341c4d77566874065d99296d485cf78b62f53de1e2fe7bf91e5d0f5e2a00fcbb2195cd314818f6eff8f22df48f58a60ddfa085d9d8252395fe432ad2b2716070e2974b6349c8b7bfffd3928266b140c52038bf9506e62104b2b2cfbb6f443001b6298672cc5f6a8ff76fdc2bd6802976db282e7bd3544e7468acea19925d69cd78363962e7c210a83dcb2b7b9bf9418c961f565dfafb09a3c353f4078ca9ea3b66c910a91606dd14efc12e4aef009
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15870);
 script_version ("1.3");
 name["english"] = "Hydra: Cisco enable";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Cisco 'enable' passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force 'Cisco enable' authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Logon password : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_timeout(0);
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl", "hydra_cisco.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

port = get_kb_item("Services/telnet");
if (! port) exit(0);	# port = 23;
if (! get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if ("Password:" >!< r) exit(0);

# Logon password is required
pass = script_get_preference("Logon password : ");
if (! pass)
{
 l = get_kb_list("Hydra/cisco/"+port);
 if (isnull(l)) exit(0);
 foreach pass (l)
   if (! pass)
    break;
 if (! pass) exit(0);
}

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;

if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cisco-enable";
argv[i++] = pass;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    # l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: "Hydra/cisco-enable/"+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following Cisco enable passwords:\n' + report);
