#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# Modified by Georges Dagousset <georges.dagousset@alert4web.com> : 
#   - extract OS and Domain
#  
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10785);
 name["english"] = "SMB NativeLanMan";
 name["francais"] = "SMB NativeLanMan";
 
 script_name(english:name["english"],
 	     francais:name["francais"]);
 
 desc["english"] = "
This plugin attempts to determine what is the
remote native lan manager name (Samba, Windows...).

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Extracts the remote native lan manager name";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl");
 script_require_keys("SMB/name");
 script_require_ports(139);
 exit(0);
}


function smb_recv(socket, length)
 {
   ____msg_header = recv(socket:socket, length:4);
   if (strlen(____msg_header) < 4)return(0);
   ____msg_trailer_length = 256 * ord(____msg_header[2]);
   ____msg_trailer_length = ____msg_trailer_length + ord(____msg_header[3]);
   if (____msg_trailer_length == 0)return(____msg_header);
   ____msg_trailer = recv(socket:socket, length:____msg_trailer_length);
   return(____msg_header+____msg_trailer);
 }

#----------------------------------------------------------------#
# Convert a netbios name to the netbios network format           #
#----------------------------------------------------------------#
function netbios_name(orig)
{
 ret = "";
 len = strlen(orig);
 for(i=0;i<16;i=i+1)
 {
   if(i >= len)
   {
     c = "CA";
   }
   else
   {
     o = ord(orig[i]);
     odiv = o/16;
     odiv = odiv + ord("A");
     omod = o%16;
     omod = omod + ord("A");
     c = raw_string(odiv, omod);
   }
 ret = ret+c;
 }
 return(ret); 
}


#-----------------------------------------------------------#
# Request a new SMB session                                 #
#-----------------------------------------------------------#
function smb_session_request(soc, remote)
{
 nb_remote = netbios_name(orig:remote);
 nb_local  = netbios_name(orig:"Nessus");
 
 session_request = raw_string(0x81, 0x00, 0x00, 0x44) + 
		  raw_string(0x20) + 
		  nb_remote +
		  raw_string(0x00, 0x20)    + 
		  nb_local  + 
		  raw_string(0x00);
 send(socket:soc, data:session_request);
 r = smb_recv(socket:soc, length:4000);
 if(ord(r[0])==0x82)return(r);
 else return(FALSE);
}

#--------------------------------------------------------------#
# Extract the UID from the result of  session_extract_uid      #
#--------------------------------------------------------------#
function session_extract_uid(reply)
{
 low = ord(reply[32]);
 high = ord(reply[33]);
 ret = high * 256;
 ret = ret + low;
 return(ret);
}



#-------------------------------------------------------------#
# Negociate (pseudo-negociate actually) the protocol          #
# of the session                                              #
#-------------------------------------------------------------#
function smb_neg_prot(soc)
{
 neg_prot = raw_string
   	(
	
 0x00, 0x00, 0x00, 0xa4,    
 0xff, 0x53, 0x4d, 0x42, 0x72, 0x00, 0x00, 0x00,  
 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  
 0x00, 0x00, 0xc7, 0x13, 0x00, 0x00, 0x01, 0x00, 
  0x00, 0x81, 0x00, 0x02, 0x50, 0x43, 0x20, 0x4e,  
 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x20, 0x50, 
  0x52, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x20, 0x31,  
 0x2e, 0x30, 0x00, 0x02, 0x4d, 0x49, 0x43, 0x52,  
 0x4f, 0x53, 0x4f, 0x46, 0x54, 0x20, 0x4e, 0x45,  
 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x53, 0x20, 0x31,  
 0x2e, 0x30, 0x33, 0x00, 0x02, 0x4d, 0x49, 0x43,  
 0x52, 0x4f, 0x53, 0x4f, 0x46, 0x54, 0x20, 0x4e,  
 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x53, 0x20,  
 0x33, 0x2e, 0x30, 0x00, 0x02, 0x4c, 0x41, 0x4e,  
 0x4d, 0x41, 0x4e, 0x31, 0x2e, 0x30, 0x00, 0x02,  
 0x4c, 0x4d, 0x31, 0x2e, 0x32, 0x58, 0x30, 0x30,  
 0x32, 0x00, 0x02, 0x53, 0x61, 0x6d, 0x62, 0x61,  
 0x00, 0x02, 0x4e, 0x54, 0x20, 0x4c, 0x41, 0x4e,  
 0x4d, 0x41, 0x4e, 0x20, 0x31, 0x2e, 0x30, 0x00,  
 0x02, 0x4e, 0x54, 0x20, 0x4c, 0x4d, 0x20, 0x30,  
 0x2e, 0x31, 0x32, 0x00,		  
	
	 );
	 
 send(socket:soc, data:neg_prot);
 r = smb_recv(socket:soc, length:1024);
 if(!r)return(FALSE);
 if(ord(r[9])==0)return(r);
 else return(FALSE);
}
 
#------------------------------------------------------#
# Set up a session                                     #
#------------------------------------------------------#
function smb_session_setup(soc)
{

  st = raw_string(0x00,0x00, 0x00, 0x51, 
	  0xFF, 0x53, 0x4D, 0x42, 0x73, 0x00, 0x00, 0x00,
	  0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	  0x00, 0xc7, 0x13, 0x00, 0x00, 0x00, 0x01, 0x00,
	  0x0d, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x02,
	  0x00, 0xc7, 0x13, 0xc3, 0x30, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x4D, 0x59,
	  0x47, 0x52, 0x4F, 0x55, 0x50, 0x00, 0x55, 0x6E,
	  0x69, 0x78, 0x00, 0x53, 0x61, 0x6d, 0x62, 0x61,
	  0x00);
	 
	 
  send(socket:soc, data:st);
  r = smb_recv(socket:soc, length:1024); 
  if(!r)return(FALSE);
  if(ord(r[9])==0)return(r);
  else return(FALSE);
}	      			




#----------------------------------------------------------------#
# 			  main()                                 #
#----------------------------------------------------------------#		




name = get_kb_item("SMB/name");
if(!name)name = "*SMBSERVER";

if(!get_port_state(139))exit(0);

 soc = open_sock_tcp(139);
 if(!soc)exit(0);
  r = smb_session_request(soc:soc,  remote:name);
  if(r)
  {
  if(smb_neg_prot(soc:soc))
  {
  r = smb_session_setup(soc:soc);
  close(soc);
  offset = 39 + ord(r[36]) * 2;
  if (offset > strlen(r))exit(0);
  os = "";
  for (i=offset;ord(r[i]);i=i+1) {
   os = os + r[i]; # possible value:'Unix','Windows NT 4.0','Windows 5.0','Windows 5.1'...
  }
  offset = i + 1;
  if(offset > strlen(r))exit(0); 
  version = "";
  for (i=offset;ord(r[i]);i=i+1) {
   version = version + r[i]; # possible value:'Samba x.y.z','Windows 2000 LAN Manager','NT LAN Manager 4.0'...
  }
  offset = i + 1;
  if(offset > strlen(r))exit(0);
  domain = "";
  for (i=offset;ord(r[i]);i=i+1) {
   domain = domain + r[i];
  }
  report = string("The remote native lan manager is : ", version, "\nThe remote Operating System is : ", os, "\nThe remote SMB Domain Name is : ", domain, "\n");
  set_kb_item(name:"SMB/NativeLanManager", value:version);
  security_note(port:139, data:report);
  }
}

 
