/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.util.StructuredMem;
import java.sql.SQLException;

class FetchChunk {
    static final int TYPE_FIRST = 1;
    static final int TYPE_LAST = 2;
    static final int TYPE_ABSOLUTE_UP = 3;
    static final int TYPE_ABSOLUTE_DOWN = 4;
    static final int TYPE_RELATIVE_UP = 5;
    static final int TYPE_RELATIVE_DOWN = 6;
    private ReplyPacket replyPacket;
    private StructuredMem replyData;
    private StructuredMem currentRecord;
    private int type;
    private int start_index;
    private int end_index;
    private int currentOffset;
    private boolean first;
    private boolean last;
    private int recordSize;
    private int chunkSize;
    private int rowsInResultSet;

    FetchChunk(int n, int n2, ReplyPacket replyPacket, int n3, int n4, int n5) throws SQLException {
        this.replyPacket = replyPacket;
        this.type = n;
        this.recordSize = n3;
        this.rowsInResultSet = n5;
        try {
            replyPacket.firstSegment();
            replyPacket.findPart(5);
        }
        catch (PartNotFound partNotFound) {
            throw new InternalJDBCError("Fetch operation delivered no data part.");
        }
        this.chunkSize = replyPacket.partArguments();
        int n6 = replyPacket.getPartDataPos();
        this.replyData = replyPacket.getPointer(n6);
        this.currentOffset = 0;
        this.currentRecord = this.replyData.getPointer(this.currentOffset * this.recordSize);
        if (n2 > 0) {
            this.start_index = n2;
            this.end_index = n2 + this.chunkSize - 1;
        } else if (n5 != -1) {
            this.start_index = n2 < 0 ? n5 + n2 + 1 : n5 - n2 + this.chunkSize;
            this.end_index = this.start_index + this.chunkSize - 1;
        } else {
            this.start_index = n2;
            this.end_index = n2 + this.chunkSize - 1;
        }
        this.determineFlags(n4);
    }

    private void determineFlags(int n) {
        boolean bl = this.replyPacket.wasLastPart();
        if (bl) {
            switch (this.type) {
                case 1: 
                case 2: 
                case 6: {
                    this.first = true;
                    this.last = true;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.last = true;
                }
            }
        }
        if (this.start_index == 1) {
            this.first = true;
        }
        if (this.end_index == -1) {
            this.last = true;
        }
        if (n != 0 && this.isForward() && this.end_index >= n) {
            this.end_index = n;
            this.chunkSize = n + 1 - this.start_index;
            this.last = true;
        }
    }

    ReplyPacket getReplyPacket() {
        return this.replyPacket;
    }

    StructuredMem getCurrentRecord() {
        return this.currentRecord;
    }

    boolean containsRow(int n) {
        if (this.start_index <= n && this.end_index >= n) {
            return true;
        }
        if (this.isForward() && this.last && n < 0) {
            return n >= this.start_index - this.end_index - 1;
        }
        if (!this.isForward() && this.first && n > 0) {
            return n <= this.end_index - this.start_index + 1;
        }
        if (this.rowsInResultSet != -1 && (this.start_index < 0 && n > 0 || this.start_index > 0 && n < 0)) {
            int n2 = n > 0 ? n - this.rowsInResultSet - 1 : n + this.rowsInResultSet + 1;
            return this.start_index <= n2 && this.end_index >= n2;
        }
        return false;
    }

    boolean move(int n) {
        if (this.currentOffset + n < 0 || this.currentOffset + n >= this.chunkSize) {
            return false;
        }
        this.unsafeMove(n);
        return true;
    }

    private void unsafeMove(int n) {
        this.currentOffset += n;
        this.currentRecord.moveBase(n * this.recordSize);
    }

    boolean setRow(int n) {
        if (this.start_index <= n && this.end_index >= n) {
            this.unsafeMove(n - this.start_index - this.currentOffset);
            return true;
        }
        if (this.isForward() && this.last && n < 0 && n >= this.start_index - this.end_index - 1) {
            this.unsafeMove(this.end_index + n + 1 - this.start_index - this.currentOffset);
            return true;
        }
        if (!this.isForward() && this.first && n > 0 && n <= this.end_index - this.start_index + 1) {
            this.unsafeMove(n - 1 - this.currentOffset);
        }
        if (this.rowsInResultSet != -1 && (this.start_index < 0 && n > 0 || this.start_index > 0 && n < 0)) {
            int n2 = n > 0 ? n - this.rowsInResultSet - 1 : n + this.rowsInResultSet + 1;
            return this.setRow(n2);
        }
        return false;
    }

    void moveToUpperBound() {
        int n = this.chunkSize - this.currentOffset - 1;
        this.currentRecord.moveBase(n * this.recordSize);
        this.currentOffset = this.chunkSize - 1;
    }

    boolean isAtUpperBound() {
        return this.currentOffset == this.chunkSize - 1;
    }

    boolean isAtLowerBound() {
        return this.currentOffset == 0;
    }

    StructuredMem getReplyData() {
        return this.replyData;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean bl) {
        this.last = bl;
    }

    public void setFirst(boolean bl) {
        this.first = bl;
    }

    public int size() {
        return this.chunkSize;
    }

    public boolean positionedAtFirst() {
        return this.first && this.currentOffset == 0;
    }

    public boolean positionedAtLast() {
        return this.last && this.currentOffset == this.chunkSize - 1;
    }

    int getLogicalPos() {
        return this.start_index + this.currentOffset;
    }

    int pos() {
        return this.currentOffset;
    }

    int getKernelPos() {
        switch (this.type) {
            case 2: 
            case 4: 
            case 5: {
                return this.start_index;
            }
        }
        return this.end_index;
    }

    boolean isForward() {
        return this.type == 1 || this.type == 3 || this.type == 5;
    }

    void setRowsInResultSet(int n) {
        this.rowsInResultSet = n;
    }

    int getStart() {
        return this.start_index;
    }

    int getEnd() {
        return this.end_index;
    }

    public String traceString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FETCH CHUNK [\n");
        switch (this.type) {
            case 1: {
                stringBuffer.append("  TYPE           : FIRST\n");
                break;
            }
            case 2: {
                stringBuffer.append("  TYPE           : LAST\n");
                break;
            }
            case 3: {
                stringBuffer.append("  TYPE           : ABSOLUTE (UP)\n");
                break;
            }
            case 4: {
                stringBuffer.append("  TYPE           : ABSOLUTE (DOWN)\n");
                break;
            }
            case 5: {
                stringBuffer.append("  TYPE           : RELATIVE (UP)\n");
                break;
            }
            case 6: {
                stringBuffer.append("  TYPE           : RELATIVE (DOWN)\n");
                break;
            }
            default: {
                stringBuffer.append("  TYPE           : UNKNOWN\n");
            }
        }
        stringBuffer.append("  START INDEX    : " + this.start_index + "\n");
        stringBuffer.append("  END INDEX      : " + this.end_index + "\n");
        stringBuffer.append("  CURRENT        : " + this.currentOffset + "\n");
        stringBuffer.append("  FIRST          : " + (this.first ? "TRUE" : "FALSE") + "\n");
        stringBuffer.append("  LAST           : " + (this.last ? "TRUE" : "FALSE") + "\n");
        stringBuffer.append("  RECORD SIZE    : " + this.recordSize + "\n");
        stringBuffer.append("  SIZE           : " + this.chunkSize + "\n");
        stringBuffer.append("  ROWS IN RESULT : " + this.rowsInResultSet + "\n");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

