// adc_dac.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// AdcConverter is the interface to the Analog Digital Systems
// D/A - A/D converter device

#ifndef ADC_DAC_H
#ifdef __GNUG__
#pragma interface
#endif
#define ADC_DAC_H

#include "converter.h"
#include "localdefs.h"

class Action;
class ProgressAction;

class AdcConverter : public RealConverter {
	typedef RealConverter Super;
public:
	AdcConverter();
	virtual ~AdcConverter();
	redefined int pause();
	redefined int stop();
	redefined int resume();
	redefined DataType bestPlayableType() { return ShortData; }
protected:
	redefined boolean isPlayableFormat(DataType type);
	redefined int doConfigure();
	redefined int doConversion(ProgressAction* askedToStop);
	redefined int doRecording(ProgressAction* askedToStop);
	redefined int waitForStop(ProgressAction *askedToStop);
	redefined int checkSampleRate(int rate);
	redefined int checkChannels(int chans);
	redefined int checkDataType(DataType type);
	redefined void fail();
	redefined void catchSignals(boolean flag);
	redefined void ignoreSignals(boolean flag);
private:
	int buffersToLoad() const { return 6; }
	int bufferSamps() { return adcBufferSamps; }
	int initialize();
	int preLoadConverter(char **buffer, int bufsize, int* nsamps);
	void setSizes(int *, int *, int *, int *);
	char* createLastBuffer(int);
	void freeLastBuffer();
	void printErrors();
	void printInfo();
private:
	static void signalCatch();
	static void signalQuit();
	static void signalIgnore();
private:
	int savedChannels;			// cached to avoid resetting
	unsigned adcBufferSamps;	// cached to save time -- samps per buffer
	char* lastBuffer;			// zeroed final buffer to write to device
};

#endif

