/*
 *   meiwmix.h -- MEIO device dependant code for mixer
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

/* Mixer Controls declarations */
#define CWMIXER_SERIALPORT 0x01
#define CWMIXER_WAVE       0x02
#define CWMIXER_MIDI       0x03
#define CWMIXER_CD         0x04
#define CWMIXER_LINE       0x05
#define CWMIXER_MIC        0x06
#define CWMIXER_MONO       0x07
#define CWMIXER_SRS        0x08
#define CWMIXER_DIGITAL    0x09
#define CWMIXER_C3D        0x0A
#define CWMIXER_AUX        0x0B
#define CWMIXER_MIXER      0x20

/* Mixer Actions */
#define SET_MUTE          0x01
#define UNMUTE            0x02
#define RESTORE_MUTE      0x03
#define SET_VOL           0x04
#define UNMUTE_RECORD     0x05
#define RESTORE_MUTE_RECORD 0x06
#define RESTORE_VOL       0x07
#define QUERY_VOL         0x08
#define OPEN_MIXER        0x20
#define CLOSE_MIXER       0x21

/* define error code for this module */
#define MEIO_MIXER_NOERROR 0x0
#define MEIO_MIXER_INVALID_PARAMETER 0x0101
#define MEIO_MIXER_ERROR 0x0102


extern HWND hWnd_MixerProc;
extern HANDLE hMixerEvent;
extern int ChildMixerProc(LPVOID);
extern USHORT MicR1Gain;
extern USHORT MicL1Gain;
extern DWORD gdwWinPlatform;
extern USHORT WtMicVolMax;
extern USHORT WtMicVolMin; 
extern USHORT MicCount;

typedef struct tMixerLineInfo {
	DWORD dwInit;
	DWORD dwSource;
	DWORD dwLineID;
} MixerLineInfo;

typedef struct tMixerDest {
	MixerLineInfo WAVE;
	MixerLineInfo MIDI;
	MixerLineInfo CD;
	MixerLineInfo LINE;
	MixerLineInfo AUX;
	MixerLineInfo MIC;
	MixerLineInfo MONO;
	MixerLineInfo DIGITAL;
	MixerLineInfo SERIAL;

} MixerDest;

#define MIC_SCALING_FACTOR 118
