/*
 *   meiosprt.c -- MEIO Manager driver support functions
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <port_types.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#include <meio_api.h>          // include general MEIO info
#include "meiomacs.h"          // include vendor driver types and macros
#include <meiogtwy.h>

ULONG FAR AnalogOwnerDefault(RF_ARGS)
{
  ANALOG_OWNER_PORT_RESOURCE FAR *pA;
  
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::AnalogOwnerDefault entry usMessage %x\n",usMessage);
  
  if (usMessage == mQUERYmsg)
    {
      pA = (ANALOG_OWNER_PORT_RESOURCE FAR *)lpResource;
      switch (lParam1) {
      case MEIO_CONNECTION_GAIN:
      case MEIO_OWNER_GAIN:
	*((LPLONG)lParam2) += pA -> data.gain;
	return(MEIO_NOERROR);
	
	
      case MEIO_OWNER_MIXING:  
	*((LPLONG)lParam2) = 0;
	return(MEIO_NOERROR);
	
	
      case MEIO_OWNER_AGC:
	if (pA->data.control & CW_ENABLE_AGC) {
	  *((LPLONG)lParam2) |= MEIO_C_ENABLE;
	} else {
	  (void)lParam2;
	} 
	return(MEIO_NOERROR);
	
	
      default:
	break;
      }
      
   }

  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::AnalogOwnerDefault exit direct from generic_rf()\n");
  return generic_rf(RF_ARGLIST);
}


ULONG FAR AnalogUserDefault(RF_ARGS)
{
  ANALOG_USER_PORT_RESOURCE FAR *pA;
  
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::AnalogUserDefault entry usMessage %x\n",usMessage);
  if (usMessage == mQUERYmsg) {
    pA = (ANALOG_USER_PORT_RESOURCE FAR *)lpResource;
    switch (lParam1) {
    case MEIO_CONNECTION_GAIN:
    case MEIO_USER_GAIN:
      *((LPLONG)lParam2) += pA -> data.gain;
      return(MEIO_NOERROR);
      

    case MEIO_USER_MIXING:
      if (pA->data.control & CW_ENABLE_MIXING) {
	*((LPLONG)lParam2) |= MEIO_C_ENABLE;
      } else {
	(void)lParam2;
      } 
      return(MEIO_NOERROR);


    case MEIO_USER_AGC:
      if (pA->data.control & CW_ENABLE_AGC) {
	*((LPLONG)lParam2) |= MEIO_C_ENABLE;
      } else {
	(void)lParam2;
      } 
      return(MEIO_NOERROR);


    default:
      break;
    }
   } 

   MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::AnalogUserDefault exit direct from generic_rf()\n");
   return generic_rf(RF_ARGLIST);
}

ULONG FAR AnalogSwitchDefault(RF_ARGS)
{
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::AnalogSwitchDefault enter+exit direct from generic_rf()\n");
  return generic_rf(RF_ARGLIST);
}

ULONG FAR AnalogInternalDefault(RF_ARGS)
{
  ANALOG_INTERNAL_RESOURCE FAR *pA;

  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::AnalogInternalDefault entry usMessage %x\n",usMessage);
  if ( CHECK_QUERY_CGAIN ) {
    pA = (ANALOG_INTERNAL_RESOURCE FAR *)lpResource;
    *((LPLONG)lParam2) += pA -> data.gain;
    return(MEIO_NOERROR);
  }
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::AnalogInternalDefault exit direct from generic_rf()\n");
  return generic_rf(RF_ARGLIST);
}

ULONG FAR DigitalOwnerDefault(RF_ARGS)   { 
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::DigitalOwnerDefault enter+exit direct from generic_rf()\n");
  return generic_rf(RF_ARGLIST);
}

ULONG FAR DigitalUserDefault(RF_ARGS)    { 
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::DigitalUserDefault enter+exit direct from generic_rf()\n");
  return generic_rf(RF_ARGLIST);
}

ULONG FAR DigitalSwitchDefault(RF_ARGS)  {
     MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::DigitalSwitchDefault enter+exit direct from generic_rf()\n");
     return generic_rf(RF_ARGLIST);
}


/* meSearchResource() - function to search for an object in a resource set.

    This uses standard RF_ARGS, plus a pointer to a placeholder variable.
    This placeholder variable is used to resume the search at the point
    the previous search stopped.  SearchResource updates the placeholder
    on each call.  If the placeholder is 0 or the pointer to the
    placeholder is zero then searching begins with the first element
    in the set.  The placeholder is not used if the pointer is null.
    The first call MUST always set the placeholder to 0 if a non-null
    pointer is used.
*/
#define END_SEARCH    0xffffffffL

ULONG FAR meSearchResource(RF_ARGS, PULONG pPlaceholder)
{
  ULONG ulRC = 0;
  ULONG idx = 0;
  PRSET Prs;
  
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::meSearchResource entry pPlaceholder %p\n",pPlaceholder);
  if (pPlaceholder) {
    if (*pPlaceholder==END_SEARCH) {
      return 0;      
    } else {
      idx = *pPlaceholder;
    } 
  } 

  if (RESOURCESET == lpResource->usType) {
    Prs = ((PRS)(PVOID)lpResource)->lpResourceSet;
    Prs = &Prs[idx];  
    while (ulRC==0 && *Prs != 0) {
      ulRC = ((*Prs)->lpMethods)(RF_NEWARGS(*Prs));
      Prs++;
      idx++; 
    } 

    if (pPlaceholder)  *pPlaceholder=idx;

  } else {
    ulRC = (lpResource->lpMethods)(RF_ARGLIST);
    if (pPlaceholder)  *pPlaceholder=END_SEARCH; 
  }
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::meSearchResource exit ulRC %lx\n",ulRC);
  return(ulRC);
}



/* RS_SendMsg() - function to send message to a Resource Object. */
ULONG FAR RS_SendMsg(RF_ARGS)
{
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::RS_SendMsg entry\n");
  if (lpResource->lpMethods) {
    MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::RS_SendMsg exit direct from call to lpResource->lpMethods()\n");
    return (lpResource->lpMethods)(RF_ARGLIST);
  } else {
    MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::RS_SendMsg exit rc %x\n",MEIO_ERROR);
    return MEIO_ERROR;
  }
}

/* RS_iterate() - function to send message to list of resources
                returns when list is completely processed or
                when non zero return code (not necessarily error,
                eg. mMATCHmsg returns ptr to matching resource.)
*/
ULONG FAR RS_iterate(RF_ARGS)
{
  ULONG ulRC = 0;
  PRSET Prs;
  
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::RS_iterate entry\n");
  if (RESOURCESET == lpResource->usType) {
    Prs = ((PRS)(PVOID)lpResource)->lpResourceSet;
    
    while (ulRC==0 && *Prs != 0) {
      ulRC = ((*Prs)->lpMethods)(RF_NEWARGS(*Prs));
      Prs++;
    } 
  } else {
    ulRC = (lpResource->lpMethods)(RF_ARGLIST);
  }
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::RS_iterate exit ulRC %lx\n",ulRC);
  return(ulRC);
}

/*
 generic connection function for STEREO ports
 simply pass connection attribute values on to resources
 exception is on QUERY Gain, since all ports will sum their
 gains, we must divide by 2 before returning to get average gain.
*/
ULONG FAR generic_scf(RF_ARGS)
{
  ULONG ulRC=0;
  
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::generic_scf entry\n");
  ulRC = generic_cf(RF_ARGLIST);

   if (ulRC==0  && (CHECK_QUERY_UCGAIN || CHECK_QUERY_OGAIN)) {
     *((LPLONG)lParam2) =  (*((LPLONG)lParam2)) / 2; 
   } 
   
   MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::generic_scf exit\n");
   return ulRC;
}


/* generic connection function
 simply pass connection attribute values on to resources
*/
ULONG FAR generic_cf(RF_ARGS)
{
  ULONG ulRC=0;
  
  MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::generic_cf entry\n");
  ulRC = generic_rf(RF_ARGLIST);
  
  if (ulRC==0) {
    ulRC = RS_iterate(RF_ARGLIST);
  } 

  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::generic_cf exit ulRC %lx\n",ulRC);
  return ulRC;
}

/* generic resource function - process message for this resource */
ULONG FAR generic_rf(RF_ARGS)
{
  ULONG ulRC=0;
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::generic_rf entry usMessage %x\n",usMessage);
  switch (usMessage) {
  case mTESTUPDATEmsg:
  case mUPDATEmsg:
    ulRC = ProcessUpdate(RF_ARGLIST);
    break;
    
  case mQUERYmsg:
    ulRC = ProcessQuery(RF_ARGLIST);
    break;
    
  case mTESTmsg:    
  case mRESERVEmsg:
  case mRELEASEmsg:
    ulRC = ProcessSharing(RF_ARGLIST);
    break;

  case mMATCHmsg: 
    if ((USHORT)lParam1==lpResource->usType    ||
	(USHORT)lParam2==lpResource->usHandle) {
      ulRC = (ULONG)lpResource;   
    } 
    break;

  case mRESETmsg:
    lpResource->usState = MEIO_OBJ_UNUSED;
    lpResource->usOwnerCount = 0;
    lpResource->lpOwnerList = 0;
    break;
    
  default:
    break;
  }
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::generic_rf exit ulRC %lx\n",ulRC);
  return ulRC;
}


/* ProcessUpdate() - process update message in generic way */
ULONG FAR ProcessUpdate(RF_ARGS)
{
  ULONG  ulRC = 0;
  USHORT usThisType;
  
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::ProcessUpdate entry lParam1 %lx\n",lParam1);
  usThisType = lpResource->usType;
  
  switch (lParam1) {
  case MEIO_CONNECTION_SHARING:        /* Update Shareability of connection    */
    ulRC = ProcessSharing(RF_ARGLIST);
    break;
    
  case MEIO_CONNECTION_MIXING :        /* Enable/Disable Connection Mixing     */
    break;

  case MEIO_USER_MIXING       :        /* Enable/Disable User Mixing           */
    if (usThisType == ANALOG_USER_PORT) {
      ulRC = ProcessMixing(RF_ARGLIST);
    } 
    break;

  case MEIO_OWNER_MIXING      :        /* Enable/Disable Owner Mixing          */
    if (usThisType == ANALOG_OWNER_PORT) {
      ulRC = ProcessMixing(RF_ARGLIST);
    } 
    break;
    
  case MEIO_CONNECTION_AGC    :        /* Enable/Disable Connection AGC        */
    break;
    
  case MEIO_USER_AGC          :        /* Enable/Disable User AGC              */
    break;

  case MEIO_OWNER_AGC         :        /* Enable/Disable Owner AGC             */
    break;

  case MEIO_CONNECTION_GAIN   :        /* Update Connection Gain               */
    break;
    
  case MEIO_USER_GAIN         :        /* Update User Gain                     */
    break;
    
  case MEIO_OWNER_GAIN        :        /* Update Owner Gain                    */
    break;

  case MEIO_CONNECTION_STATE  :        /* update Connection State */
    break;

  default:
    ulRC = MEIO_NC_INVALID_ATTRIBUTE;
    break;
  }
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::ProcessUpdate exit ulRC %lx\n",ulRC);
  return (ulRC);
}

/* meFindResourceSet() - find a resource set that matches a pair of handles */
ULONG FAR meFindResourceSet(HMEIO hMeio,       
                          USHORT OwnerPort,    
                          USHORT UserPort,
                          PRS FAR *pprs)       
{
  ULONG   ulRC = MEIO_NOERROR;
  PRS     Prs;
  int     i;
  
  (void)hMeio;     

  MW_SYSLOG_4(TRACE_MEIO_CORE,"meiosprt::meFindResourceSet entry hMeio %lx OwnerPort %x UserPort %x\n",
	 hMeio,OwnerPort,UserPort);
  for (i=0; AllResources[i]; i++) {
    Prs = AllResources[i];
    
    if ((Prs->lpResourceSet)[0]->usHandle==OwnerPort  &&
	(Prs->lpResourceSet)[1]->usHandle==UserPort  ) {
       *pprs = Prs; 
      return (MEIO_NOERROR);
    }
  } 
  
  *pprs = 0;
  
  if (0==meFindResource(hMeio,OwnerPort)) ulRC = MEIO_NC_INVALID_OWNER;
  else
    if (0==meFindResource(hMeio,UserPort))  ulRC = MEIO_NC_INVALID_USER;
    else                                    ulRC = MEIO_NC_INVALID_CONNECTION;
  
  MW_SYSLOG_3(TRACE_MEIO_CORE,"meiosprt::meFindResourceSet exit prs %p ulRC %lx\n",
	 *pprs,ulRC);
  return(ulRC);
}

/*   meFindResource() - find a resource that matches a handle */
PRESOURCE FAR meFindResource(HMEIO hMeio, USHORT Port)
{
  PRESOURCE Pr=0;
  int       i;
  
  (void)hMeio; 
  
  MW_SYSLOG_3(TRACE_MEIO_CORE,"meiosprt::meFindResource entry hMeio %lx Port %x\n",
	 hMeio,Port);

  for (i=0; AllResources[i] && 0==Pr; i++) {
    Pr = (PRESOURCE)RS_SendMsg((PMEIO_CONNECTION)0,
			       GETRP(AllResources[i]),
			       mMATCHmsg,
			       0,Port);
  } 
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::meFindResource exit Pr %p\n", Pr);
  return(Pr);
}


ULONG FAR ProcessQuery(RF_ARGS)
{
  ULONG ulRC=MEIO_NOERROR;
  
  VOID_ARGS;
  
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::ProcessQuery entry usMessage %x\n",
	 usMessage);

  if (  usMessage==mQUERYmsg && ( lParam1==MEIO_CONNECTION_SHARING))
    ulRC = QuerySharing(RF_ARGLIST);
  
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiosprt::ProcessQuery exit ulRC %lx\n",ulRC);
  return ulRC;
}

ULONG FAR ProcessMixing(RF_ARGS)  { VOID_ARGS;
 MW_SYSLOG_1(TRACE_MEIO_CORE,"meiosprt::ProcessMixing entry+exit ulRC 0\n");
 return 0; 
}
