/*
 *   dspdmfnc.c -- DSP Manager user space daemon code
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <stdio.h>
#include <stdlib.h>                    // Needed for getenv() function
#include <string.h>

#include "dspmgr.h"
#include "dspmgri.h"                   // Internal Equates
#include "dspdmfnc.h"                  // Equates
#include "dspactiv.h"                  // Function prototypes
#include "dspalloc.h"                  // Function prototypes
#include "dspfixup.h"                  // Function prototypes
#include "dspfxutl.h"                  // Function prototypes
#include "dspfree.h"                   // Function prototypes
#include "dspgpc.h"                    // Function prototypes
#include "dspinit.h"                   // Function prototypes
#include "dspipc.h"                    // Function prototypes
#include "dspitcb.h"                   // Function prototypes
#include "dspload.h"                   // Function prototypes
#include "dspmem.h"                    // Function prototypes
#include "dspquery.h"                  // Function prototypes
#include "dspabil.h"                   // Function prototypes
#include "dspbios.h"                   // CH01 Needed for PDD_Copy_QueryBuffer
//#include "mwevents.h"                  // CH02 Needed for lowpower support
#include "dspsrv.h"

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspAllocateSegment                               */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspAllocateSegment for DAEMON                   */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspAllocateSegment(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG           ulRC;                    // error return code
   RPARM_ALLOCSEG *pRParm;
   PSZ             pszTemp = NULL;          // Initialization assumed by code


   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspAllocateSegment entry\n");
   pRParm = (RPARM_ALLOCSEG *)&pg->DAEMONpacket;

   /*************************************************************************/
   /* if string length==0, then pass null pointer                           */
   /*************************************************************************/
   if (pg->Buffer1[0] != 0)
      pszTemp = (PSZ)pg->Buffer1;
   if (DAEMON_DspVerifyPointer((PVOID)pRParm->ALLOCSEG_hTask) == DSP_NOERROR)
   {
      ulRC = AllocateSegment(pRParm->ALLOCSEG_hTask, pszTemp,
         pRParm->ALLOCSEG_ulSize, pRParm->ALLOCSEG_ulAlign,
         pRParm->ALLOCSEG_usFlags, pRParm->ALLOCSEG_ulDSPAddr, (PRSEG *)
         &pAnsHead->dwHandle);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;


   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspAllocateSegment exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspChangeCPF                                     */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspChangeCPF for DAEMON                         */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspChangeCPF(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;
   RPARM_CHCPF *pRParm;


   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeCPF entry\n");
   pRParm = (RPARM_CHCPF *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->CHCPF_hTask) == DSP_NOERROR)
      ulRC = ChangeCPF(pRParm->CHCPF_hTask, pRParm->CHCPF_lCPF);
   else
      ulRC = DSP_INV_HANDLE;

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeCPF exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspChangeDMA                                     */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspChangeDMA for DAEMON                         */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspChangeDMA(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;
   RPARM_CHDMA *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeDMA entry\n");
   pRParm = (RPARM_CHDMA *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->CHDMA_hTask) == DSP_NOERROR)
      ulRC = ChangeDMA(pRParm->CHDMA_hTask, pg->Buffer1, pRParm->CHDMA_lPacket
         , pRParm->CHDMA_lMaxPacketSize, pRParm->CHDMA_lMaxPacketPF,
         pRParm->CHDMA_usStride, pRParm->CHDMA_usHold);
   else
      ulRC = DSP_INV_HANDLE;

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeDMA exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspChangeModuleState                             */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspChangeModuleState for DAEMON                 */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspChangeModuleState(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_CHMODSTATE *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeModuleState entry\n");

   pRParm = (RPARM_CHMODSTATE *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->CHMODSTATE_hMOD) == DSP_NOERROR)
   {
      ulRC = ChangeModuleState((PRMOD)pRParm->CHMODSTATE_hMOD,
         pRParm->CHMODSTATE_usFlags);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeModuleState exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspChangeTaskState                               */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspChangeTaskState for DAEMON                   */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspChangeTaskState(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_CHTASKSTATE *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeTaskState entry\n");
   pRParm = (RPARM_CHTASKSTATE *)&pg->DAEMONpacket;

   PRINT_DEBUG_FOPEN(APIFILEPTR, APIFILENAME, "a", "dspdmfnc::DAEMON_DspChangeTaskState <<< dspChangeTaskState");
   PRINT_DEBUG(APIFILEPTR, "  hTask (0x%lX)", pRParm->CHTASKSTATE_hTask);
   PRINT_DEBUG(APIFILEPTR, "  usFlags (0x%X)\n", pRParm->CHTASKSTATE_usFlags);
   PRINT_DEBUG_FCLOSE(APIFILEPTR);

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->CHTASKSTATE_hTask) ==
      DSP_NOERROR) {
      ulRC = ChangeTaskState((PRTSK)pRParm->CHTASKSTATE_hTask,
         pRParm->CHTASKSTATE_usFlags);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspChangeTaskState exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspConnectGPC                                    */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspConnectGPC      for DAEMON                   */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspConnectGPC(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC = DSP_NOERROR;      // initialization assumed by code
   RPARM_CONNGPC *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspConnectGPC entry\n");
   pRParm = (RPARM_CONNGPC *)&pg->DAEMONpacket;


   /*************************************************************************/
   /* Check the user and owner handles. The handles can be NULL for BIOS    */
   /* tasks or they must be valid handles as reported by DspVerifyPointer() */
   /*************************************************************************/

   if (pRParm->CONNGPC_hOwnerTask != NULL)

      /**********************************************************************/
      /* if pointer is not NULL then call DspVerifyPointer()                */
      /**********************************************************************/

      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->CONNGPC_hOwnerTask);

   if (ulRC == DSP_NOERROR && (pRParm->CONNGPC_hUserTask != NULL))

      /**********************************************************************/
      /* if ptr is not NULL and no error then call DspVerifyPointer()       */
      /**********************************************************************/

      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->CONNGPC_hUserTask);

   /*************************************************************************/
   /* Assure usProtocol = 0                                                 */
   /*************************************************************************/

   if (pRParm->CONNGPC_usProtocol != 0)
      ulRC = DSP_INV_PARAMETER;

   if (ulRC == DSP_NOERROR)            /* if no errors in handles then      */
                                       /* connectgpc                        */
      ulRC = ConnectGPC((PRTSK)pRParm->CONNGPC_hOwnerTask, (PSZ)pg->Buffer1,
         (PRTSK)pRParm->CONNGPC_hUserTask, (PSZ)pg->Buffer2, (PULONG)
         &pAnsHead->dwHandle);

   pAnsHead->dwReturnCode = (DWORD) ulRC;
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspConnectGPC exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspConnectIPC                                    */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspConnectIPC      for DAEMON                   */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/****************************************************************************/

VOID DAEMON_DspConnectIPC(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_CONNIPC *pRParm;
   PRIPCTE    pripcte;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspConnectIPC entry\n");

   pRParm = (RPARM_CONNIPC *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->CONNIPC_hTask) == DSP_NOERROR) {
      ulRC = ConnectIPC((PRTSK)pRParm->CONNIPC_hTask,
         pRParm->CONNIPC_pfnIPCNotice, pRParm->CONNIPC_usType, (HIPC *)
         &pAnsHead->dwHandle);

      if (ulRC==DSP_NOERROR) { /* CH01 if OK then fixup IPCTE */
         pripcte = (PRIPCTE)pRParm->CONNIPC_phIPC;
         pripcte->IPCTE_usENVHandle = *(USHORT *)&pg->Buffer1;

         // for IPC identification.

         pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;

         memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                     (PVOID) &(((HIPC)pAnsHead->dwHandle)->IPCTE_usMask) ,
                     pAnsHead->dwBufSize );

      } /* endif */
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspConnectIPC exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspConnectITCB                                   */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspConnectITCB     for DAEMON                   */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspConnectITCB(PMWMGR_ANSWER_HEAD pAnsHead)
{
   ULONG      ulRC = DSP_NOERROR;      // Initialization assumed by code
   RPARM_CONNITCB *pRParm;


   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspConnectITCB entry\n");
   pRParm = (RPARM_CONNITCB *)&pg->DAEMONpacket;

   /*************************************************************************/
   /* Check the user and owner handles. The handles can be NULL for BIOS    */
   /* tasks or they must be valid handles as reported by DspVerifyPointer() */
   /*************************************************************************/

   if (pRParm->CONNITCB_hPTask != NULL)

      /**********************************************************************/
      /* if pointer is not NULL then call DspVerifyPointer()                */
      /**********************************************************************/

      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->CONNITCB_hPTask);

   if (ulRC == DSP_NOERROR && (pRParm->CONNITCB_hSTask != NULL))

      /**********************************************************************/
      /* if ptr is not NULL and no error then call DspVerifyPointer()       */
      /**********************************************************************/

      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->CONNITCB_hSTask);

   if (ulRC == DSP_NOERROR)            /* if no errors in handles then      */
                                       /* connectitcb                       */
      ulRC = ConnectITCB((PRTSK)pRParm->CONNITCB_hPTask, (PSZ)pg->Buffer1,
         (PRTSK)pRParm->CONNITCB_hSTask, (PSZ)pg->Buffer2);

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspConnectITCB exit\n");
   return ;
}

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspDisconnectIPC                                 */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspDisconnectIPC      for DAEMON                */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspDisconnectIPC(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG          ulRC;                    // error return code
   RPARM_DISCIPC *pRParm;
   USHORT         usTmpMask;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspDisconnectIPC entry\n");
   pRParm = (RPARM_DISCIPC *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->DISCIPC_hIPC) == DSP_NOERROR) {
         
      // for IPC identification.
      usTmpMask = pRParm->DISCIPC_hIPC->IPCTE_usMask;

      ulRC = DisconnectIPC((HIPC)pRParm->DISCIPC_hIPC);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   if (ulRC == DSP_NOERROR) {
 
     pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;

     memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                 (PVOID) &usTmpMask ,
                 pAnsHead->dwBufSize );
     }

   pAnsHead->dwReturnCode = (DWORD) ulRC;
 
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspDisconnectIPC exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspDisconnectGPC                                 */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspDisconnectGPC      for DAEMON                */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspDisconnectGPC(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC = DSP_NOERROR;      // Initialization assumed by code
   RPARM_DISCGPC *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspDisconnectGPC entry\n");
   pRParm = (RPARM_DISCGPC *)&pg->DAEMONpacket;

   /*************************************************************************/
   /* Allow NULL task handles (representing BIOS tasks). Later code in      */
   /* dspgpc.c assures that both handles are not NULL                       */
   /*************************************************************************/

   if (pRParm->DISCGPC_hOwnerTask != NULL)

      /**********************************************************************/
      /* if pointer is not NULL then call DspVerifyPointer()                */
      /**********************************************************************/

      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->DISCGPC_hOwnerTask);

   if (ulRC == DSP_NOERROR && (pRParm->DISCGPC_hUserTask != NULL))

      /**********************************************************************/
      /* if ptr is not NULL and no error then call DspVerifyPointer()       */
      /**********************************************************************/

      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->DISCGPC_hUserTask);

   if (ulRC == DSP_NOERROR)            /* if no errors so far               */
      {
      ulRC = DisconnectGPC((PRTSK)pRParm->DISCGPC_hOwnerTask, (PSZ)pg->Buffer1
         , (PRTSK)pRParm->DISCGPC_hUserTask, (PSZ)pg->Buffer2, (USHORT)0);

      /**********************************************************************/
      /* API doesn't care if Task was freeed or not                         */
      /**********************************************************************/

      if ((ulRC == DSP_OWNER_TASK_FREE) || (ulRC == DSP_USER_TASK_FREE) ||
         (ulRC == DSP_OW_US_TASK_FREE))
         ulRC = DSP_NOERROR;
   }
   else
      ulRC = DSP_INV_HANDLE;           /* a handle is invalid               */

   pAnsHead->dwReturnCode = (DWORD) ulRC;
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspDisconnectGPC exit\n");
   return ;

}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspDisconnectITCB                                */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspDisconnectITCB     for DAEMON                */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspDisconnectITCB(PMWMGR_ANSWER_HEAD pAnsHead)
{
   ULONG      ulRC = DSP_NOERROR;      // Initialization assumed by code
   RPARM_DISCITCB *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspDisconnectITCB entry\n");
   pRParm = (RPARM_DISCITCB *)&pg->DAEMONpacket;

   if (pRParm->DISCITCB_hPTask != NULL)
      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->DISCITCB_hPTask);

   if ((ulRC == DSP_NOERROR) && (pRParm->DISCITCB_hSTask != NULL))
      ulRC = DAEMON_DspVerifyPointer((PVOID)pRParm->DISCITCB_hSTask);

   if (ulRC == DSP_NOERROR) {
      ulRC = DisconnectITCB((PRTSK)pRParm->DISCITCB_hPTask, (PSZ)pg->Buffer1,
         (PRTSK)pRParm->DISCITCB_hSTask, (PSZ)pg->Buffer2, (USHORT)0);
   }
   else
      ulRC = DSP_INV_HANDLE;

   /*************************************************************************/
   /* API doesn't care if Task was freeed or not                            */
   /*************************************************************************/

   if ((ulRC == DSP_OWNER_TASK_FREE) || (ulRC == DSP_USER_TASK_FREE) || (ulRC
      == DSP_OW_US_TASK_FREE))
      ulRC = DSP_NOERROR;

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspDisconnectITCB exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspFreeModule                                    */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspFreeModule         for DAEMON                */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspFreeModule(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_FREEMOD *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspFreeModule entry\n");
   pRParm = (RPARM_FREEMOD *)&pg->DAEMONpacket;

   pRParm->FREEMOD_usFlags = 0;        // clear out flags for IDC

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->FREEMOD_hMOD) == DSP_NOERROR) {
      ulRC = FreeModule((PRMOD)pRParm->FREEMOD_hMOD, pRParm->FREEMOD_usFlags);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;


   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspFreeModule exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspFreeSegment                                   */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspFreeSegment        for DAEMON                */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspFreeSegment(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_FREESEG *pRParm;
   PRSEG      prseg;


   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspFreeSegment entry\n");

   pRParm = (RPARM_FREESEG *)&pg->DAEMONpacket;

   prseg = pRParm->FREESEG_hSeg;
   if (DAEMON_DspVerifyPointer((PVOID)pRParm->FREESEG_hSeg) == DSP_NOERROR) {
      if (prseg->SEG_achValid == SEGVALIDATE) {

         /*******************************************************************/
         /* Turn on Flag to prevent free of DDS                             */
         /*******************************************************************/

         pRParm->FREESEG_hSeg->SEG_usflg |= SEG_DDS_INV;

         ulRC = FreeSegment((PRSEG)pRParm->FREESEG_hSeg);
      }
      else
         ulRC = DSP_INV_HANDLE;
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspFreeSegment exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspFreeTask                                      */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspFreeTask           for DAEMON                */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspFreeTask(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_FREETASK *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspFreeTask entry\n");
   pRParm = (RPARM_FREETASK *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->FREETASK_hTask) == DSP_NOERROR)
   {
      ulRC = FreeTask((PRTSK)pRParm->FREETASK_hTask);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspFreeTask exit\n");

   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspInit                                          */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspInit for DAEMON                              */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/****************************************************************************/

VOID DAEMON_DspInit(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_INIT *pRParm;
   PSZ        pszFilename;
   //HANDLE     hThread;
   //DWORD      ThreadId;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspInit entry\n");
   pRParm = (RPARM_INIT *)&pg->DAEMONpacket;

   pRParm->INIT_usState = DSP_INIT_ACTIVE;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->INIT_hDSP) == DSP_NOERROR) {

      pszFilename = (PSZ)pg->Buffer1;
      if (0 == *pszFilename) {         /* empty or NULL file name           */
//         pszFilename = getenv("MWOSNAME");/* default MWAVE/OS file          */
           pszFilename = GetDSPStringAttribute(DSPATTR_OSFILENAME, (PRDSP)pRParm->INIT_hDSP);
      }                                /* endif                             */
      if (NULL == pszFilename) {       /* MWOSNAME not set                  */
         ulRC = DSP_FILE_NOT_FOUND;
      }
      else {
         ulRC = InitDSP((PRDSP)pRParm->INIT_hDSP, pszFilename,
            pRParm->INIT_usState);

         /*******************************************************************/
         /* CH01 CH02 Low-power notification                                */
         /* Create a new thread to notify all clients about the INIT        */
         /* so that the manager main thread is not blocked.  This           */
         /* function will block until all clients respond, and some         */
         /* clients may do manager API calls which would cause a deadlock   */
         /* if a new thread was not started here.                           */
         /*******************************************************************/
         #ifdef MWNS_ENABLED
         hThread = CreateThread( NULL,             /* Default security desc.*/        
			         4096,             /* Initial stack size    */
			         (LPTHREAD_START_ROUTINE) signalDspInit,  
			         NULL,             /* Thread argument       */
                                 0,                /* Run immediately       */
                                 &ThreadId );      /* Thread ID             */               
         #endif  // #ifdef MWNS_ENABLED
         
      }                                /* endif                             */
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspInit exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspLabelToOffset                                 */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspLabelToOffset for DAEMON                     */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspLabelToOffset(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_LABTOADD *pRParm;
   PRTSK      prtsk;
   ULONG      ulDSPAddr;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLabelToOffset entry\n");
   pRParm = (RPARM_LABTOADD *)&pg->DAEMONpacket;

   /*************************************************************************/
   /* Check for valid task handle. Search every Code Segment and every Data */
   /* Segment in the task until a label is found.                           */
   /*************************************************************************/

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->LABTOADD_hTask) == DSP_NOERROR)
   {
      prtsk = pRParm->LABTOADD_hTask;
      if (prtsk->TSK_achValid == TSKVALIDATE) {

         ulRC = LabelToAddress(prtsk, (PSZ)pg->Buffer1, &ulDSPAddr);
         if (ulRC == DSP_NOERROR)
            pAnsHead->dwHandle = (DWORD) ulDSPAddr;

      } else {
         ulRC = DSP_INV_HANDLE;
      }

   } else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLabelToOffset exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspLoadModule                                    */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspLoadModule for DAEMON                        */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspLoadModule(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_LOADMOD *pRParm;
   PSZ        pszTemp1 = NULL;         // Initialization assumed by code
   PSZ        pszTemp2 = NULL;         // Initialization assumed by code

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLoadModule entry\n");
   pRParm = (RPARM_LOADMOD *)&pg->DAEMONpacket;

   /*************************************************************************/
   /* if string length==0, then pass null pointer                           */
   /*************************************************************************/

   if (pg->Buffer1[0] != 0)
      pszTemp1 = (PSZ)pg->Buffer1;
   if (pg->Buffer2[0] != 0)
      pszTemp2 = (PSZ)pg->Buffer2;
   if (DAEMON_DspVerifyPointer((PVOID)pRParm->LOADMOD_hDSP) == DSP_NOERROR) {
      ulRC = LoadModule((PRDSP)pRParm->LOADMOD_hDSP, pszTemp1, pszTemp2,
         pRParm->LOADMOD_usFlags, (PRMOD *)&pAnsHead->dwHandle);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }                                   /* endif                             */

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLoadModule exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspLoadSegment                                   */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspLoadSegment for DAEMON                       */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspLoadSegment(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_LOADSEG *pRParm;
   PSZ        pszTemp = NULL;          // Initialization assumed by code

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLoadSegment entry\n");
   pRParm = (RPARM_LOADSEG *)&pg->DAEMONpacket;

   if (pg->Buffer3[0] != 0)
      pszTemp = (PSZ)pg->Buffer3;
   if (DAEMON_DspVerifyPointer((PVOID)pRParm->LOADSEG_hTask) == DSP_NOERROR) {
      ulRC = LoadSegment((PRTSK)pRParm->LOADSEG_hTask, (PSZ)pg->Buffer1, (PSZ)
         pg->Buffer2, pszTemp,         // Virtual Name
         pRParm->LOADSEG_ulDSPAddr, (PRSEG *)&pAnsHead->dwHandle);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;
 
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLoadSegment exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspLoadTask                                      */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspLoadTask for DAEMON                          */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspLoadTask(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_LOADTASK *pRParm;
   PSZ        pszTemp = NULL;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLoadTask entry\n");
   pRParm = (RPARM_LOADTASK *)&pg->DAEMONpacket;

   if (pg->Buffer3[0] != 0)
      pszTemp = (PSZ)pg->Buffer3;
   if ((DAEMON_DspVerifyPointer((PVOID)pRParm->LOADTASK_hMod) == DSP_NOERROR)
      && (DAEMON_DspVerifyPointer((PVOID)pRParm->LOADTASK_hDSP) == DSP_NOERROR
      )) {
      ulRC = LoadTask((PRMOD)pRParm->LOADTASK_hMod, (PRDSP)
      pRParm->LOADTASK_hDSP, (PSZ)pg->Buffer1, (PSZ)pg->Buffer2, pszTemp,  // Virtual Name
         pRParm->LOADTASK_usFlags, pRParm->LOADTASK_pRQHWBuf, (PRTSK *)
         &pAnsHead->dwHandle);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspLoadTask exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspNameToModuleHandle                            */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspNameToModuleHandle                           */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspNameToModuleHandle(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_NAMEMODULEH *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspNameToModuleHandle entry\n");
   pRParm = (RPARM_NAMEMODULEH *)&pg->DAEMONpacket;

   PRINT_DEBUG_FOPEN(APIFILEPTR, APIFILENAME, "a", "dspdmfnc::DAEMON_DspNameToModuleHandle <<< dspNameToModuleHandle");
   PRINT_DEBUG(APIFILEPTR, "  pszInstanceName (%s)", pg->Buffer1);
   PRINT_DEBUG(APIFILEPTR, "  phMOD (0x%lX)\n",
        pRParm->NAMEMODULEH_phModule);
   PRINT_DEBUG_FCLOSE(APIFILEPTR);

   ulRC = NameToModuleHandle(pg->prmgrTail, (PSZ)pg->Buffer1, (PRMOD *)
      &pAnsHead->dwHandle);

   pAnsHead->dwReturnCode = (DWORD) ulRC;
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspNameToModuleHandle exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspNameToSegmentHandle                           */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspNameToSegmentHandle                          */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspNameToSegmentHandle(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_NAMESEGH *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspNameToSegmentHandle entry\n");
   pRParm = (RPARM_NAMESEGH *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->NAMESEGH_hTask) == DSP_NOERROR)
   {
      ulRC = NameToSegmentHandle(pRParm->NAMESEGH_hTask, (PSZ)pg->Buffer1,
         (PRSEG *)&pAnsHead->dwHandle);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspNameToSegmentHandle exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspNameToTaskHandle                              */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspNameToTaskHandle                             */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspNameToTaskHandle(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_NAMETASKH *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspNameToTaskHandle entry\n");
   pRParm = (RPARM_NAMETASKH *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->NAMETASKH_hMod) == DSP_NOERROR)
   {
      ulRC = NameToTaskHandle(pRParm->NAMETASKH_hMod, (PSZ)pg->Buffer1, (PRTSK
         *)&pAnsHead->dwHandle);
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspNameToTaskHandle exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspQueryDSPInfo                                  */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspQueryDSPInfo for DAEMON                      */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspQueryDSPInfo(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_QDSPINFO *pRParm;
   PVOID      pQueryBuffer;            /* CH01 */


   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryDSPInfo entry\n");
   pRParm = (RPARM_QDSPINFO *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->QDSPINFO_hDsp) == DSP_NOERROR) {

      pQueryBuffer=malloc(pg->usBufferSize); /* CH01 Begin */
      ulRC = QueryDSPInfo(pRParm->QDSPINFO_hDsp, &pg->usBufferSize,
         pQueryBuffer, pRParm->QDSPINFO_pDspInfoBuf);

      pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;
      
      if (ulRC==DSP_NOERROR) 
        memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                    (PVOID) pQueryBuffer ,
                    pAnsHead->dwBufSize );
       
      free(pQueryBuffer);                     /* CH01 End */
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryDSPInfo exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspQueryManagerInfo                              */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspQueryManagerInfo for DAEMON                  */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspQueryManagerInfo(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_QMANINFO *pRParm;
   PVOID      pQueryBuffer;            /* CH01 Begin */

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryManagerInfo entry\n");
   pRParm = (RPARM_QMANINFO *)&pg->DAEMONpacket;

   pQueryBuffer=malloc(pg->usBufferSize); /* CH01 */

   ulRC = QueryManagerInfo(&pg->usBufferSize, pQueryBuffer,
                           pRParm->QMANINFO_pMgrInfoBuf);

   pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;
      
   if (ulRC==DSP_NOERROR) 
     memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                 (PVOID) pQueryBuffer ,
                 pAnsHead->dwBufSize );
       
   free(pQueryBuffer);                     /* CH01 End */

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryManagerInfo exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspQueryMiscInfo                                 */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspQueryMiscInfo for DAEMON                     */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/****************************************************************************/

VOID DAEMON_DspQueryMiscInfo(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC=OK;                    // error return code
   RPARM_QMISCINFO *pRParm;
   PVOID      pQueryBuffer;            /* CH02 */
   PRMGR      prmgr;
   struct {                            /* CH01 Backdoor structure */
      ULONG Command;
      ULONG ReturnCode;
      ULONG Parm1;
      ULONG Parm2;
   } *pBackdoor;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryMiscInfo entry\n");
   pRParm = (RPARM_QMISCINFO *)&pg->DAEMONpacket;

   /**********************************************************************/
   /* CH01 begin: backdoor entry for diagnostics CTP                     */
   /* If the following conditions exist then the door is opened:         */
   /*   usType=0xFFFE, usBufferSize=0, and pMiscInfoBuf points to shared */
   /*   memory.  Then the shared memory is accessed and the contents     */
   /*   is used for various diagnositc commands as follows:              */
   /*   Command   Inputs   Outputs        Description                    */
   /*   -------   ------   -------        --------------------------     */
   /*      1      none     Parm2          Read internal bus capacity     */
   /*      2      Parm1    Parm2          Read/Set internal bus capacity */
   /*      3      none     Parm1, Parm2   Read addr of PG/Memory test    */
   /*                                                                    */
   /* When the action is completed Command is set to zero and the        */
   /* ReturnCode is set to an appropriate value.                         */
   /**********************************************************************/
   if ((pRParm->QMISCINFO_usType==0xfffe) && (pg->usBufferSize==0)) {
      if (ulRC==0) {  /* Backdoor has been opened */
         pBackdoor = pRParm->QMISCINFO_pMiscInfoBuf;
         switch (pBackdoor->Command) {
         case 1:  /* Read internal BusCapacity only */
            prmgr = pg->prmgrTail;    /* get pointer to mgr structure */
            pBackdoor->Parm2 = prmgr->MGR_ulBusCapacity;  /* Read old */
            pBackdoor->ReturnCode = 0;  /* Successful */
            break;
         case 2:  /* Set internal BusCapacity only */
            prmgr = pg->prmgrTail;    /* get pointer to mgr structure */
            if (prmgr->MGR_ulBusCapacity==prmgr->MGR_ulRemBusCapacity) {
               pBackdoor->Parm2 = prmgr->MGR_ulBusCapacity;  /* Read old */
               prmgr->MGR_ulBusCapacity = pBackdoor->Parm1;  /* Set new */
               prmgr->MGR_ulRemBusCapacity = pBackdoor->Parm1;
               pBackdoor->ReturnCode = 0;  /* Successful */
            }
            else pBackdoor->ReturnCode = 1; /* failed */
            break;
         case 3:  /* Return pointer to PG and Memory mgmt status */
            pBackdoor->Parm1 = (ULONG) pg;  /* return addr of global buffer */
            pBackdoor->Parm2 = (ULONG) &(pg->ulPermAllocsPeak);  /* addr mtst */
            pBackdoor->ReturnCode = 0;  /* Successful */
            break;
         default:
            pBackdoor->ReturnCode = 2;  /* Unknown cmd */
            break;
         } /* endswitch */
         pBackdoor->Command = 0;  /* indicate completion */
      } /* endif */
      ulRC = DSP_INV_PARAMETER;
   } /* CH01 End */

   else {  /* CH01 Normal Execution */
      if (DAEMON_DspVerifyPointer((PVOID)pRParm->QMISCINFO_hMisc)
         == DSP_NOERROR) {
         pQueryBuffer=malloc(pg->usBufferSize); /* CH02 Begin */
         ulRC = QueryMiscInfo(pRParm->QMISCINFO_usType, pRParm->QMISCINFO_hMisc,
            &pg->usBufferSize, pQueryBuffer, pRParm->QMISCINFO_pMiscInfoBuf);

         pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;
      
         if (ulRC==DSP_NOERROR)
           memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                       (PVOID) pQueryBuffer ,
                       pAnsHead->dwBufSize );
       
         free(pQueryBuffer);                     /* CH01 End */
       }
       else {
         ulRC = DSP_INV_HANDLE;
       }
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryMiscInfo exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspQueryModuleInfo                               */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspQueryModuleinfo for DAEMON                   */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspQueryModuleInfo(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_QMODINFO *pRParm;
   PVOID      pQueryBuffer;            /* CH01 */

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryModuleInfo entry\n");
   pRParm = (RPARM_QMODINFO *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->QMODINFO_hMod) == DSP_NOERROR) {
      pQueryBuffer=malloc(pg->usBufferSize); /* CH01 Begin */
      ulRC = QueryModuleInfo(pRParm->QMODINFO_hMod, &pg->usBufferSize,
         pQueryBuffer, pRParm->QMODINFO_pModInfoBuf);

      pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;
      
      if (ulRC==DSP_NOERROR) 
        memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                    (PVOID) pQueryBuffer ,
                    pAnsHead->dwBufSize );
       
      free(pQueryBuffer);                     /* CH01 End */
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQueryModuleInfo exit\n");
   return ;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_DspQueryTaskInfo                                 */
/*                                                                          */
/* FUNCTION: OS/2:  Process DspQueryTaskInfo for DAEMON                     */
/*                                                                          */
/* INPUT: (NONE)                                                            */
/*                                                                          */
/* OUTPUT: (NONE)                                                           */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

VOID DAEMON_DspQueryTaskInfo(PMWMGR_ANSWER_HEAD pAnsHead)

{
   ULONG      ulRC;                    // error return code
   RPARM_QTASKINFO *pRParm;
   PVOID      pQueryBuffer;            /* CH01 */

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQuerytaskInfo entry\n");
   pRParm = (RPARM_QTASKINFO *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->QTASKINFO_hTask) == DSP_NOERROR)
   {
      pQueryBuffer=malloc(pg->usBufferSize); /* CH01 Begin */
      ulRC = QueryTaskInfo(pRParm->QTASKINFO_hTask, &pg->usBufferSize,
         pQueryBuffer, pRParm->QTASKINFO_pTaskInfoBuf);

      pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;
      
      if (ulRC==DSP_NOERROR) 
        memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                    (PVOID) pQueryBuffer ,
                    pAnsHead->dwBufSize );
       
      free(pQueryBuffer);                     /* CH01 End */
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspQuerytaskInfo exit\n");
   return ;
}

VOID DAEMON_DspAbilities(PMWMGR_ANSWER_HEAD pAnsHead)
{
   ULONG            ulRC;               // error return code
   RPARM_ABILITIES *pRParm;
   PVOID            pQueryBuffer;  

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspAbilities entry\n");
   pRParm = (RPARM_ABILITIES *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->ABILITIES_hDsp) == DSP_NOERROR) {

      pQueryBuffer=malloc(pg->usBufferSize); /* CH01 Begin */

      ulRC = DspBIOS_Abilities(pRParm->ABILITIES_hDsp,
                               &pg->usBufferSize,
		   	       pQueryBuffer );

      pAnsHead->dwBufSize = (DWORD) pg->usBufferSize;
      
      if (ulRC==DSP_NOERROR) 
        memcpy( (PVOID) ((PBYTE)pAnsHead + sizeof(MWMGR_ANSWER_HEAD)),
                    (PVOID) pQueryBuffer ,
                    pAnsHead->dwBufSize );
       
      free(pQueryBuffer);                     /* CH01 End */
   }
   else {
      ulRC = DSP_INV_HANDLE;
   }

   pAnsHead->dwReturnCode = (DWORD) ulRC;
 
   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspAbilities exit\n");
   return;
}

VOID DAEMON_DspReset(PMWMGR_ANSWER_HEAD pAnsHead)
{
   ULONG      ulRC;                    // error return code
   RPARM_RESETDSP *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspReset entry\n");
   pRParm = (RPARM_RESETDSP *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->RESETDSP_hDsp) == DSP_NOERROR)

     ulRC = DspBIOS_Reset(pRParm->RESETDSP_hDsp);

   else
     ulRC = DSP_INV_HANDLE;

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspReset exit\n");
   return;
}

VOID DAEMON_DspRun(PMWMGR_ANSWER_HEAD pAnsHead)
{
   ULONG         ulRC;                    // error return code
   RPARM_RUNDSP *pRParm;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspRun entry\n");
   pRParm = (RPARM_RUNDSP *)&pg->DAEMONpacket;

   if (DAEMON_DspVerifyPointer((PVOID)pRParm->RUNDSP_hDsp) == DSP_NOERROR)

     ulRC = DspBIOS_Run(pRParm->RUNDSP_hDsp);

   else
     ulRC = DSP_INV_HANDLE;

   pAnsHead->dwReturnCode = (DWORD) ulRC;

   MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspRun exit\n");
   return;
}

/****************************************************************************/
/*                                                                          */
/* SUBROUTINE NAME: DAEMON_VerifyPointer                                    */
/*                                                                          */
/* FUNCTION: This Routine will verify that a pointer resides in the PG      */
/*           address space.                                                 */
/*                                                                          */
/* INPUT: PVOID ptr                                                         */
/*                                                                          */
/* OUTPUT: DSP_INV_HANDLE if the pointer is not in the address space.       */
/*         DSP_NOERROR    if the pointer is     in the address space.       */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/****************************************************************************/

RC DAEMON_DspVerifyPointer(PVOID ptr)
{
   
  MW_SYSLOG_1(TRACE_MANAGER_SPECIFIC,"dspdmfnc::DAEMON_DspVerifyPointer entry+exit\n");
  return DSP_NOERROR;

  /* @TBD if ( IsBadWritePtr(ptr, sizeof(PULONG)) )
     return DSP_INV_HANDLE;
   else
   return DSP_NOERROR; */
}
