/****************************************************************************
** $Id: mthread.h,v 1.3 2002/01/18 21:05:50 maksik Exp $
**
** Definition of MThread class
**
** Created : 931107
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef MTHREAD_H
#define MTHREAD_H

//#ifndef QT_H
//#include <qwindowdefs.h>
//#endif // QT_H

//#if defined(QT_THREAD_SUPPORT)
#include <limits.h>

#define M_EXPORT
#ifndef FALSE
#define FALSE false
#endif
#ifndef TRUE
#define TRUE true
#endif
typedef unsigned long  HANDLE;

class Mt {

public:

};

class MMutexPrivate;

const int M_MUTEX_NORMAL = 0;
const int M_MUTEX_RECURSIVE = 1;


class M_EXPORT MMutex : public Mt
{
    friend class MWaitCondition;
    friend class MWaitConditionPrivate;

public:
    MMutex(bool recursive = FALSE);
    virtual ~MMutex();

    void lock();
    void unlock();
    bool locked();

private:
    MMutexPrivate * d;

#if defined(M_DISABLE_COPY)
    MMutex( const MMutex & );
    MMutex &operator=( const MMutex & );
#endif
};

class MLock {
public:
	MLock(MMutex& mutex, bool bLock = true) : m_mutex(mutex), m_bLocked(false) {
		if (bLock)
		{
			m_mutex.lock();
			m_bLocked = true;
		}
	}
	~MLock() {
		if (m_bLocked)
			m_mutex.unlock();
	}
	void lock(){
		m_mutex.lock();
		m_bLocked = true;
	}
	void unlock(){
		m_bLocked = false;
		m_mutex.unlock();
	}
private:
	MLock();              // no implementation
	MLock(const MLock& ); // no implementation	
	MMutex& m_mutex;
	bool m_bLocked;
};

class MThreadPrivate;
class MObject;
class MEvent;

class M_EXPORT MThread : public Mt
{
    friend class MThreadPrivate;
public:
    static HANDLE currentThread();
    HANDLE getHandle();
    bool isCurrent();
    //static void postEvent( MObject *,MEvent * );

    static void exit();

    MThread(bool bAutoDelete = false);
    virtual ~MThread();

    // default argument causes thread to block indefinately
    bool wait( unsigned long time = ULONG_MAX );
    bool wait( MMutex* mutex, unsigned long time = ULONG_MAX );

    void start();

    bool finished() const;
    bool running() const;


protected:
    virtual void run() = 0;

    static void sleep( unsigned long );
    static void msleep( unsigned long );
    static void usleep( unsigned long );

private:
    MThreadPrivate * d;
    bool  m_bAutoDelete;

#if defined(M_DISABLE_COPY)
    MThread( const MThread & );
    MThread &operator=( const MThread & );
#endif
};

class MWaitConditionPrivate;

class M_EXPORT MWaitCondition : public Mt
{
public:
    MWaitCondition();
    virtual ~MWaitCondition();

    // default argument causes thread to block indefinately
    bool wait( unsigned long time = ULONG_MAX );
    bool wait( MMutex *mutex, unsigned long time = ULONG_MAX );

    void wakeOne();
    void wakeAll();

private:
    MWaitConditionPrivate * d;

#if defined(M_DISABLE_COPY)
    MWaitCondition( const MWaitCondition & );
    MWaitCondition &operator=( const MWaitCondition & );
#endif
};

class MSemaphorePrivate;

class M_EXPORT MSemaphore : public Mt
{
public:
    MSemaphore( int );
    virtual ~MSemaphore();

    int available() const;
    int total() const;

    // postfix operators
    int operator++(int);
    int operator--(int);

    int operator+=(int);
    int operator-=(int);


private:
    MSemaphorePrivate *d;

#if defined(M_DISABLE_COPY)
    MSemaphore(const MSemaphore &);
    MSemaphore &operator=(const MSemaphore &);
#endif
};

//#endif

#endif
