/***************************************************************************
                          gnucache.cpp  -  implementation of the MGnuCache
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
//#include "controller.h"

#include "preferences.h"

#include "gnucache.h"
#include "gnunode.h"
#include "gnudirector.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MGnuCache::MGnuCache(MGnuDirector* pCntr)
{
	m_pDirector = pCntr;

	m_CurrentPos   = 0;

	/*LoadNodes("GnuCache.net");

	{
		MLock lock(m_cachemutex);
		std::vector<Node>::iterator itNode;
		for(itNode = m_pDirector->GetPrefs()->m_HostServers.begin(); itNode != m_pDirector->GetPrefs()->m_HostServers.end(); itNode++)
			UpdateCache(*itNode);
	}*/
	m_pDirector->AttachCache(this);
}

MGnuCache::~MGnuCache()
{
	m_pDirector->DetachCache(this);
}

void MGnuCache::LoadNodes(CString HostFile)
{
	/*MLock lock(m_cachemutex);
	FILE * pFile;
	if ( (pFile = fopen(HostFile.c_str(), "r")) )
	{
		CString strNode;
		Node	newNode;
		char buf[1024];

		while ( !feof(pFile) )
		{
			strNode = fgets(buf,1024,pFile);
			// Address
			int posFront  = strNode.find(":", 0);
			newNode.Host = StrtoIP(strNode.substr(0, posFront));

			// Port
			int posBack   = posFront;
			posFront      = strNode.find(":", posBack + 1);
			newNode.Port = atoi(strNode.substr(posBack + 1, posFront - posBack - 1).c_str());

			// Distance
			newNode.Distance = atoi(strNode.substr(posFront + 1, strNode.length() - posFront).c_str());

			newNode.Ping	   = 0;
			newNode.Speed      = 0;

			newNode.ShareSize  = 0;
			newNode.ShareCount = 0;

			if(m_pDirector->CheckIP(newNode.Host))
			{
				bool Duplicate = false;

				std::list<Node>::iterator itNode;
				for(itNode = m_Cached.begin(); itNode != m_Cached.end(); itNode++)
					if((*itNode).Host.S_addr == newNode.Host.S_addr && (*itNode).Port == newNode.Port)
						Duplicate = true;

				if(!Duplicate)
					m_Current.push_back(newNode);
			}
		}

		fclose(pFile);
	}*/
}

void MGnuCache::SaveNodes(CString HostFile)
{
	/*MLock lock(m_cachemutex);
	FILE * pFile;

	if ( pFile = fopen(HostFile.c_str(), "w") )
	{
		int     NodeCount = 0;
		CString strNode;
		
		std::list<Node>::iterator itNode;
		for(itNode = m_Current.begin(); itNode != m_Current.end(); itNode++)
			if(m_pDirector->CheckIP((*itNode).Host))
			{
				strNode  =  IPtoStr((*itNode).Host)      + ":";
				strNode += DWrdtoStr((*itNode).Port)     + ":";
				strNode += DWrdtoStr((*itNode).Distance) + "\n";

				if(NodeCount > NODECACHE_SIZE)
					break;
				else
				{
					fputs(strNode.c_str(), pFile);
					NodeCount++;
				}
			}

		for(itNode = m_Cached.begin(); itNode != m_Cached.end(); itNode++)
			if(m_pDirector->CheckIP((*itNode).Host))
			{
				strNode =  IPtoStr((*itNode).Host)       + ":";
				strNode += DWrdtoStr((*itNode).Port)     + ":";
				strNode += DWrdtoStr((*itNode).Distance) + "\n";

				if(NodeCount > NODECACHE_SIZE)
					break;
				else
				{
					fputs(strNode.c_str(), pFile);
					NodeCount++;
				}
			}
	}*/
}

void MGnuCache::UpdateCache(Node NetNode)
{
	//bool Found = false;
	if( NetNode.Port != 0 &&
	    NotRecent(NetNode.Host) &&
	    m_pDirector->CheckIP(NetNode.Host) &&
	    m_pDirector->IsOkForDirectConnect(NetNode.Host))
	{
		MLock lock(m_cachemutex);
		if(m_Current.size() >= NODECACHE_SIZE)
			m_Current.pop_front();
		m_Current.push_back(NetNode);
	}
}

bool MGnuCache::NotRecent(IP Host)
{
	MLock lock(m_cachemutex);
	std::list<IP>::iterator itIP;
	for(itIP = m_RecentIPs.begin(); itIP != m_RecentIPs.end(); itIP++)
		if( (*itIP).S_addr == Host.S_addr)
		{
			m_RecentIPs.erase(itIP);
			m_RecentIPs.push_back(Host);
			return false;
		}

	m_RecentIPs.push_back(Host);

	if(m_RecentIPs.size() > 5)
		m_RecentIPs.pop_front();
	return true;
}

void MGnuCache::GetNodeList(std::list<Node>& list)
{
	MLock lock(m_cachemutex);
	list.clear();
	list = m_Current;
}

void MGnuCache::SendCache(MGnuNode* pNode, int nHosts)
{
	MLock lock(m_cachemutex);
	
	IP LocalHost;
	LocalHost._ip.a = 127; LocalHost._ip.b = 0; LocalHost._ip.c = 0; LocalHost._ip.d = 1;
	int HostsSent = 0, pos, Count;

	while(HostsSent < nHosts)
	{
		Count = 0;
		if(m_Current.size())
		{
			pos = rand() % m_Current.size();
			std::list<Node>::iterator itNode;
			for(itNode = m_Current.begin(); itNode != m_Current.end(); itNode++)
			{
				if(Count == pos)
				{
					if((*itNode).Host.S_addr != LocalHost.S_addr)
						pNode->Send_Host(*itNode);
					break;
				}
				Count++;
			}
		}
		else if(m_Cached.size())
		{
			pos = rand() % m_Cached.size();			
			std::list<Node>::iterator itNode;
			for(itNode = m_Cached.begin(); itNode != m_Cached.end(); itNode++)
			{
				if(Count == pos)
				{
					if((*itNode).Host.S_addr != LocalHost.S_addr)
						pNode->Send_Host(*itNode);
					break;
				}
				Count++;
			}
		}
		HostsSent++;
	}
}

bool MGnuCache::GetRandomNode(Node& rNode)
{
	MLock lock(m_cachemutex);
	
	int pos;
	//int NewCache = rand() % 2;

	if(/*NewCache && */m_Current.size())
	{
		pos = rand() % m_Current.size();

		int Count = 0;
		std::list<Node>::iterator itNode;
		for(itNode = m_Current.begin(); itNode != m_Current.end(); itNode++)
		{
			if(Count == pos)
			{
				rNode = (*itNode);
				m_Current.erase(itNode);
				return true;
			}
			Count++;
		}
	}
	/*else if(m_Cached.size())
	{
		pos = rand() % m_Cached.size();

		int Count = 0;
		std::list<Node>::iterator itNode;
		for(itNode = m_Cached.begin(); itNode != m_Cached.end(); itNode++)
		{
			if(Count == pos)
			{
				rNode = (*itNode);
				m_Cached.erase(itNode);
				return true;
			}
			Count++;
		}
	}*/
	return false;
}