/***************************************************************************
                          asyncfile.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(INLCUDE_ICON_H)
#define INLCUDE_ICON_H

time_t xtime();
DWORD GenID();

class MGnuNode;

#pragma pack(1)

struct GUID {
	u_char a[16];
	static void Create(GUID*);
	static const GUID G_NULL;
	bool operator==(const GUID& other) const {return 0==memcmp(a,other.a,sizeof(GUID));}
};

#define GUID_NULL GUID::G_NULL
#define CreateGuid GUID::Create

union IP										// Size 4 	
{
	struct { u_char s_b1,s_b2,s_b3,s_b4; } S_un_b;
	struct { u_short s_w1,s_w2; }          S_un_w;
	struct {BYTE a, b, c, d;}              _ip;
	u_long S_addr;

	/*inline int operator > (union IP& first)
	{	
		bool result = false;

		if(_ip.a > first._ip.a)
			result = true;
		else if(_ip.a == first._ip.a)
		{
			if(_ip.b > first._ip.b)
				result = true;
			else if(_ip.b == first._ip.b)
			{
				if(_ip.c > first._ip.c)
					result = true;
				else if(_ip.c == first._ip.c)
				{
					if(_ip.d > first._ip.d)
						result = true;
				}
			}
		}
	
		return result;
	};*/
};

struct ExIP
{
	int  a, b, c, d; // 0 - 255 is ip num, -1 is wildcard
	bool mode;       // false for deny, true for allow
};

#pragma pack()

struct SharedFile
{
	CString Name;
	CString NameLower;
	CString Path;

	DWORD Size;
	DWORD Matches;
	DWORD Uploads;
	
	SharedFile() : Size(0), Matches(0), Uploads(0) {}
	SharedFile(const SharedFile& orig) :
		Name(orig.Name),
		NameLower(orig.NameLower),
		Path(orig.Path),
		Size(orig.Size),
		Matches(orig.Matches),
		Uploads(orig.Uploads)
	{}
	const SharedFile& operator=(const SharedFile& orig)
	{
		Name = orig.Name;
		NameLower = orig.NameLower;
		Path = orig.Path;
		Size = orig.Size;
		Matches = orig.Matches;
		Uploads = orig.Uploads;
		return *this;
	}
};

struct SharedDirectory
{
	CString 	Name;
	bool		Recursive;
	long long	Size;
	DWORD		FileCount;
	//
	SharedDirectory() : Recursive(false), Size(0), FileCount(0) {}
	SharedDirectory(const SharedDirectory& orig) : Name(orig.Name), Recursive(orig.Recursive), Size(orig.Size), FileCount(orig.FileCount) {}
	const SharedDirectory& operator=(const SharedDirectory& orig){
		Name = orig.Name;
		Recursive = orig.Recursive;
		Size = orig.Size;
		FileCount = orig.FileCount;
		return *this;
	}
};

struct ShareChange
{
	DWORD Index;
	DWORD Type;
	DWORD Value;
};

#define MAX_QUERY_LEN 255

struct QueryComp
{
	char		Query[MAX_QUERY_LEN+1];
	GUID		QueryGuid;
	MGnuNode*   Origin;
	int			nHops;
};

struct Result
{	
	// File info
	CString   Name;
	CString   NameLower;
	DWORD     FileIndex;
	DWORD     Size;
	// extra info
	CString   Extra;
	
	// Node info
	IP		  Host;
	WORD      Port;
	int       Speed;
	CString	  Vendor;

	// Flags
	bool Firewall;
	bool OpenSlots;
	bool Busy;
	bool Stable;
	bool ActualSpeed;


	// Push info
	MGnuNode* Origin;
	GUID      PushID;
	int		  Distance;

	// Download info
	DWORD     Status;
	DWORD     StatusUpdateTime;
	DWORD     ChangeTime;
	int       ErrorCode;
	bool      bServerIsUp;   // true if we recieved anything from it ever
	int       nConErrors;    // counter of consequitive connection errors
	int       nPushTimeouts; // counter of consequitive push timeouts
	// Numerical ID for searches
	DWORD     dwID;
	// consructor
	Result(){
		dwID = 0;
		StatusUpdateTime = ChangeTime = xtime();
		ErrorCode = REASON_UNDEFINED;
		Status = TRANSFER_NEW;
		bServerIsUp = false;
		nConErrors = 0;
		nPushTimeouts = 0;
	}
	Result(const Result& orig) :
		Name(orig.Name),
		NameLower(orig.NameLower),
		FileIndex(orig.FileIndex),
		Size(orig.Size),
		Extra(orig.Extra),
		Host(orig.Host),
		Port(orig.Port),
		Speed(orig.Speed),
		Vendor(orig.Vendor),
		Firewall(orig.Firewall),
		OpenSlots(orig.OpenSlots),
		Busy(orig.Busy),
		Stable(orig.Stable),
		ActualSpeed(orig.ActualSpeed),
		Origin(orig.Origin),
		PushID(orig.PushID),
		Distance(orig.Distance),
		Status(orig.Status),
		StatusUpdateTime(orig.StatusUpdateTime),
		ChangeTime(orig.ChangeTime),
		ErrorCode(orig.ErrorCode),
		bServerIsUp(orig.bServerIsUp),
		nConErrors(orig.nConErrors),
		nPushTimeouts(orig.nPushTimeouts),
		dwID(orig.dwID)
	{}
	const Result& operator=(const Result& orig){
	    Name = orig.Name;
		NameLower = orig.NameLower;
		FileIndex = orig.FileIndex;
		Size = orig.Size;
		Extra = orig.Extra;
		Host = orig.Host;
		Port = orig.Port;
		Speed = orig.Speed;
		Vendor = orig.Vendor;
		Firewall = orig.Firewall;
		OpenSlots = orig.OpenSlots;
		Busy = orig.Busy;
		Stable = orig.Stable;
		ActualSpeed = orig.ActualSpeed;
		Origin = orig.Origin;
		PushID = orig.PushID;
		Distance = orig.Distance;
		Status = orig.Status;
		StatusUpdateTime = orig.StatusUpdateTime;
		ChangeTime = orig.ChangeTime;
		ErrorCode = orig.ErrorCode;
		bServerIsUp = orig.bServerIsUp;
		nConErrors = orig.nConErrors;
		nPushTimeouts = orig.nPushTimeouts;
		dwID = orig.dwID;
		return *this;
	}
};

typedef std::vector<Result> ResultVec;

struct ResultGroup
{
	CString  Name;
	CString  NameLower;
	DWORD    Size;
	DWORD    AvgSpeed;

	std::vector<int> ResultList;

	DWORD    dwID;

	static int  SortBy;
	static bool Reverse;
	
	ResultGroup() : Size(0), AvgSpeed(0), dwID(0) {}
	ResultGroup(const ResultGroup& orig) :
		Name(orig.Name),
		NameLower(orig.NameLower),
		Size(orig.Size),
		AvgSpeed(orig.AvgSpeed),
		ResultList(orig.ResultList),
		dwID(orig.dwID)
	{}
	const ResultGroup& operator=(const ResultGroup& orig){
		Name = orig.Name;
		NameLower = orig.NameLower;
		Size = orig.Size;
		AvgSpeed = orig.AvgSpeed;
		ResultList = orig.ResultList;
		dwID = orig.dwID;
		return *this;
	}
};

// utility functions
inline void MakeLower(CString& s){s.make_lower();}
inline void MakeUpper(CString& s){s.make_upper();}
void MakeLower(char *);
void MakeUpper(char *);
CString StripWhite (CString str);
char* StripWhite(char* string );
void ReplaceSubStr(CString&, CString, CString);

bool asc2num( char * arg, double * pRet );
bool asc2num( char * arg, int * pRet );

bool CreateDirectory(const CString&);
bool MoveFile(const CString&, const CString&);
bool DeleteFile(const CString& path);
CString ExpandPath(CString path);
bool FileExists(const CString& path);

bool QueryMatch(CString Result, const CString& Query);
void MakeWordList(LPSTR szQuery, std::vector<char*>& QWords);
void MakeWordList(LPSTR szQuery, std::vector<char*>& QWords, std::vector<char*>& QWords);
bool MatchWordList(const CString& ResultLower, const std::vector<char*>& QWords, bool bMatchAll = true);
CString MakeSearchOfFilename(const CString& Name);

// simple limited capasity queue
// TODO: proper construction/destruction of the elements
template <class T>
class TSimpleQueue {
public:
	TSimpleQueue(int nCap = 256) : m_pBuffer(NULL){
		setCapasity(nCap);
	}
	~TSimpleQueue(){
		delete [] m_pBuffer;
	}
	//
	void setCapasity(int nCap){
		if (m_pBuffer)
			delete [] m_pBuffer;
		m_pBuffer = new T[nCap];
		m_nCap = nCap;
		m_pHead = m_pBuffer;
		m_pTail = m_pBuffer;
		m_bFull = false;
	}
	bool push(const T& t){
		if (m_bFull)
			return false;
		*m_pTail = t;
		m_pTail++;
		if ((m_pTail-m_pBuffer)>=m_nCap) // '>' should never occur
			m_pTail -= m_nCap;
		m_bFull = (m_pHead == m_pTail);
		return true;
	}
	void pop(){
	    ASSERT(size());
		m_pHead++;
		if ((m_pHead-m_pBuffer)>=m_nCap) // '>' should never occur
			m_pHead -= m_nCap;
		m_bFull = false;// cant be full anymore
	}
	const T& front(){ ASSERT(size()); return *m_pHead; }
	const T& back(){ ASSERT(size()); return *( m_pTail!=m_pBuffer ? (m_pTail-1) : (m_pTail+m_nCap-1) ); }
	int size(){ return m_bFull ? m_nCap : (m_nCap+(m_pTail-m_pHead)) % m_nCap; }
	bool isFull(){ return m_bFull;}
	bool find(const T& t){
		T* pT = m_pHead;
		for (int n = size(); n>0; ++pT, --n){
			if ((pT-m_pBuffer)>=m_nCap)
				pT -= m_nCap;
			if (*pT == t)
				return true;
		}
		return false;
	}
private:
	TSimpleQueue(const TSimpleQueue&);
	const TSimpleQueue& operator=(TSimpleQueue&);
	//
	T* m_pBuffer;
	int m_nCap;
	T* m_pHead;
	T* m_pTail;
	bool m_bFull;
};

#endif