/* 
   MultiSync - A PIM data synchronization program

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   In addition, as a special exception, Bo Lincoln <lincoln@lysator.liu.se>
   gives permission to link the code of this program with
   the OpenSSL library (or with modified versions of OpenSSL that use the
   same license as OpenSSL), and distribute linked combinations including
   the two.  You must obey the GNU General Public License in all
   respects for all of the code used other than OpenSSL.  If you modify
   this file, you may extend this exception to your version of the
   file, but you are not obligated to do so.  If you do not wish to
   do so, delete this exception statement from your version.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES 
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, 
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS 
   SOFTWARE IS DISCLAIMED.
*/

/*
 *  $Id: tray.c,v 1.2 2003/07/27 19:34:32 lincoln Exp $
 */

/* includes */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <gnome.h>
#include "callbacks.h"
#include "eggtrayicon.h"
#include "tray.h"

#include "syncengine.h"

extern GtkWidget* mainwindow; 

/* globals */
static EggTrayIcon *tray = NULL;
static GtkWidget *menu = NULL;

static gboolean tray_show_mainwindow(GtkWidget *widget, gboolean *force) {
    if (mainwindow && !*force) {
      sync_hide_gui();
    } else {
      sync_show_gui();
    }	
    return FALSE;
}

static gboolean tray_clicked(GtkWidget *widget, GdkEventButton *event) {
    static gboolean force = FALSE;

    if (event->type != GDK_BUTTON_PRESS) {
	return FALSE;
    }
    if (event->button == 1) {
	tray_show_mainwindow(widget, &force);
    } else  if (event->button == 3) {
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL,
		NULL, event->button, event->time);
	return TRUE;
    }

    return FALSE;
}

static gboolean tray_destroyed(GtkWidget *widget, GdkEvent *event) {
    return TRUE;
}

void show_tray() {
  GtkWidget *image, *box, *item;
  char *filename;
  static gboolean force = TRUE;

  tray = egg_tray_icon_new("Multisync");

  filename = g_strdup_printf("%s/%s", PACKAGE_DATA_DIR, 
			     "pixmaps/multisync-16.png");
  image = gtk_image_new_from_file (filename);
  g_free(filename);

  box = gtk_event_box_new();
  g_signal_connect(G_OBJECT(box), "button_press_event", 
		   G_CALLBACK(tray_clicked), NULL);

  menu = gtk_menu_new ();

  /* Main menu */
  item = gtk_menu_item_new_with_label ("Main Window");
  g_signal_connect(G_OBJECT (item), "activate", 
		   G_CALLBACK (tray_show_mainwindow), &force);
  gtk_widget_show (item);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);

  /* About */
  item = gtk_image_menu_item_new_from_stock (GNOME_STOCK_MENU_ABOUT, NULL);
  g_signal_connect(G_OBJECT (item), "activate", 
		   G_CALLBACK (on_aboutmenu_activate), NULL);
  gtk_widget_show (item);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);

  /* Quit */
#if 0
  item = gtk_image_menu_item_new_from_stock (GNOME_STOCK_MENU_QUIT, NULL);
  g_signal_connect(G_OBJECT (item), "activate", 
		   G_CALLBACK (on_mainwindow_delete_event), NULL);
  gtk_widget_show (item);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
#endif

  gtk_container_add(GTK_CONTAINER(box), image);
  gtk_container_add(GTK_CONTAINER(tray), box);
  gtk_widget_show_all(GTK_WIDGET(tray));

  g_signal_connect(G_OBJECT(tray), "destroy-event", 
		   G_CALLBACK(tray_destroyed), NULL);


}

static void
tray_gconf_notify (GConfClient *gconf,
		   guint        cnxn_id,
		   GConfEntry  *entry,
		   gpointer     user_data)
{
  GConfValue  *value;
  gboolean     checked;
  
  if (entry && !strcmp(gconf_entry_get_key(entry), 
			 SYNC_GCONF_PATH"/no_tray_icon")) {
    value = gconf_entry_get_value (entry);
    checked = gconf_value_get_bool (value);
    if (checked && tray) {
      gtk_widget_destroy(GTK_WIDGET(tray));
      tray = NULL;
    }
    if (!checked && !tray)
      show_tray();
  }    
}

void init_tray() {
  GConfClient *gconf = gconf_client_get_default ();

  gconf_client_notify_add (gconf, SYNC_GCONF_PATH"/no_tray_icon",
			   tray_gconf_notify, NULL, NULL, NULL);
  if (!gconf_client_get_bool (gconf, SYNC_GCONF_PATH"/no_tray_icon", 
			      NULL))
    show_tray();
  
  g_object_unref(gconf);

}
