/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.Drawable;
import base.drawable.DrawnBoxSet;
import base.drawable.Method;
import base.drawable.NestingStacks;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;
import viewer.common.CustomCursor;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.histogram.StatlineDialog;
import viewer.timelines.InfoDialogForDrawable;
import viewer.timelines.InfoPanelForDrawable;
import viewer.timelines.SearchTreeTrunk;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InitializableDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.Profile;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.SearchPanel;
import viewer.zoomable.SearchableView;
import viewer.zoomable.SummarizableView;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class CanvasTimeline
extends ScrollableObject
implements SearchableView,
SummarizableView {
    private static final long serialVersionUID = 13300L;
    private static final Drawable.Order INCRE_STARTTIME_ORDER = Drawable.INCRE_STARTTIME_ORDER;
    private static final Drawable.Order DECRE_STARTTIME_ORDER = Drawable.DECRE_STARTTIME_ORDER;
    private TreeTrunk treetrunk;
    private YaxisMaps y_maps;
    private YaxisTree tree_view;
    private BoundedRangeModel y_model;
    private Method[] methods;
    private String[] y_colnames;
    private Frame root_frame;
    private TimeBoundingBox timeframe4imgs;
    private ChangeListener change_listener;
    private ChangeEvent change_event;
    private int num_rows;
    private int row_height;
    private NestingStacks nesting_stacks;
    private Map map_line2row;
    private DrawnBoxSet drawn_boxes;
    private boolean isConnectedComposite;
    private SearchTreeTrunk tree_search;
    private Date zero_time;
    private Date init_time;
    private Date final_time;

    public CanvasTimeline(ModelTime modelTime, TreeTrunk treeTrunk, BoundedRangeModel boundedRangeModel, YaxisMaps yaxisMaps, String[] stringArray, Method[] methodArray) {
        super(modelTime);
        this.treetrunk = treeTrunk;
        this.y_maps = yaxisMaps;
        this.tree_view = this.y_maps.getTreeView();
        this.y_model = boundedRangeModel;
        this.y_colnames = stringArray;
        this.methods = methodArray;
        TreeNode treeNode = this.treetrunk.getTreeRoot();
        short s = treeNode.getTreeNodeID().depth;
        this.nesting_stacks = new NestingStacks(this.tree_view);
        this.map_line2row = null;
        this.drawn_boxes = new DrawnBoxSet(this.tree_view);
        this.timeframe4imgs = null;
        short s2 = (short)(s - Parameters.INIT_SLOG2_LEVEL_READ + 1);
        if (s2 < 0) {
            s2 = 0;
        }
        this.treetrunk.growInTreeWindow(treeNode, s2, new TimeBoundingBox(treeNode));
        this.treetrunk.setNumOfViewsPerUpdate(6);
        this.isConnectedComposite = false;
        if (this.methods != null && this.methods.length > 0) {
            this.isConnectedComposite = this.methods[0].isConnectCompositeState();
        }
        this.tree_search = new SearchTreeTrunk(this.treetrunk, this.tree_view, this.isConnectedComposite);
        this.root_frame = null;
        this.change_event = null;
        this.change_listener = null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.change_event = new ChangeEvent(this);
        this.change_listener = changeListener;
    }

    public Dimension getMinimumSize() {
        int n = 0;
        if (Debug.isActive()) {
            Debug.println("CanvasTimeline: min_size = (0," + n + ")");
        }
        return new Dimension(0, n);
    }

    public Dimension getMaximumSize() {
        if (Debug.isActive()) {
            Debug.println("CanvasTimeline: max_size = (32767,32767)");
        }
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getJComponentHeight() {
        int n = this.tree_view.getRowCount() * this.tree_view.getRowHeight();
        int n2 = this.y_model.getMaximum() - this.y_model.getMinimum() + 1;
        if (n2 > n) {
            return n2;
        }
        return n;
    }

    private void fireChangeEvent() {
        if (this.change_event != null) {
            this.change_listener.stateChanged(this.change_event);
        }
    }

    protected void initializeAllOffImages(TimeBoundingBox timeBoundingBox) {
        if (Profile.isActive()) {
            this.zero_time = new Date();
        }
        if (this.root_frame == null) {
            this.root_frame = (Frame)SwingUtilities.windowForComponent(this);
        }
        if (this.timeframe4imgs == null) {
            this.timeframe4imgs = new TimeBoundingBox(timeBoundingBox);
        }
        Routines.setComponentAndChildrenCursors(this.root_frame, CustomCursor.Wait);
        this.num_rows = this.tree_view.getRowCount();
        this.row_height = this.tree_view.getRowHeight();
        boolean bl = this.treetrunk.updateTimeWindow(this.timeframe4imgs, timeBoundingBox) == 1;
        this.nesting_stacks.initialize(bl);
        if (Profile.isActive()) {
            this.init_time = new Date();
        }
        this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        if (this.map_line2row == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(this.root_frame, "Error in updating YaxisMaps!");
            }
            this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        }
        this.drawn_boxes.initialize();
    }

    protected void finalizeAllOffImages(TimeBoundingBox timeBoundingBox) {
        this.drawn_boxes.finish();
        this.map_line2row = null;
        this.nesting_stacks.finish();
        this.timeframe4imgs.setEarliestTime(timeBoundingBox.getEarliestTime());
        this.timeframe4imgs.setLatestTime(timeBoundingBox.getLatestTime());
        this.fireChangeEvent();
        Routines.setComponentAndChildrenCursors(this.root_frame, CustomCursor.Normal);
        if (Profile.isActive()) {
            this.final_time = new Date();
        }
        if (Profile.isActive()) {
            Profile.println("CanvasTimeline.finalizeAllOffImages(): init. time = " + (this.init_time.getTime() - this.zero_time.getTime()) + " msec.,   total time = " + (this.final_time.getTime() - this.zero_time.getTime()) + " msec.");
        }
    }

    protected void drawOneOffImage(Image image, TimeBoundingBox timeBoundingBox) {
        if (Debug.isActive()) {
            Debug.println("CanvasTimeline: drawOneOffImage()'s offImage = " + image);
        }
        if (image != null) {
            Drawable drawable;
            int n = image.getWidth(this);
            int n2 = image.getHeight(this);
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setPaint((Color)Parameters.BACKGROUND_COLOR.toValue());
            graphics2D.fillRect(0, 0, n, n2);
            CoordPixelImage coordPixelImage = new CoordPixelImage(this, this.row_height, timeBoundingBox);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setColor(Color.cyan);
            for (int i = 0; i < this.num_rows; ++i) {
                if (this.tree_view.isExpanded(i)) continue;
                int n3 = coordPixelImage.convertRowToPixel(i);
                graphics2D.drawLine(0, n3, n - 1, n3);
            }
            if (Debug.isActive() || Profile.isActive()) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(0, 0, 0, this.getHeight());
            }
            this.nesting_stacks.reset();
            this.drawn_boxes.reset();
            Iterator iterator = this.treetrunk.iteratorOfAllDrawables(timeBoundingBox, INCRE_STARTTIME_ORDER, this.isConnectedComposite, true);
            while (iterator.hasNext()) {
                drawable = (Drawable)iterator.next();
                if (!drawable.getCategory().isVisible()) continue;
                drawable.setStateRowAndNesting(coordPixelImage, this.map_line2row, this.nesting_stacks);
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            iterator = this.treetrunk.iteratorOfRealDrawables(timeBoundingBox, INCRE_STARTTIME_ORDER, this.isConnectedComposite, true);
            while (iterator.hasNext()) {
                drawable = (Drawable)iterator.next();
                if (!drawable.getCategory().isVisible()) continue;
                n6 += drawable.drawOnCanvas(graphics2D, coordPixelImage, this.map_line2row, this.drawn_boxes);
                n4 += drawable.getNumOfPrimitives();
            }
            Iterator iterator2 = this.treetrunk.iteratorOfLowestFloorShadows(timeBoundingBox, INCRE_STARTTIME_ORDER, true);
            while (iterator2.hasNext()) {
                Shadow shadow = (Shadow)iterator2.next();
                if (!shadow.getCategory().isVisible()) continue;
                n6 += shadow.drawOnCanvas(graphics2D, coordPixelImage, this.map_line2row, this.drawn_boxes);
                n4 += shadow.getNumOfPrimitives();
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Parameters.ARROW_ANTIALIASING.toValue());
            iterator = this.treetrunk.iteratorOfAllDrawables(timeBoundingBox, INCRE_STARTTIME_ORDER, this.isConnectedComposite, false);
            while (iterator.hasNext()) {
                drawable = (Drawable)iterator.next();
                if (!drawable.getCategory().isVisible()) continue;
                n7 += drawable.drawOnCanvas(graphics2D, coordPixelImage, this.map_line2row, this.drawn_boxes);
                n5 += drawable.getNumOfPrimitives();
            }
            if (Profile.isActive()) {
                Profile.println("CanvasTimeline.drawOneOffImage(): R_NestAble = " + n6 + "/" + n4 + ",  " + "R_NestLess = " + n7 + "/" + n5);
            }
            graphics2D.dispose();
        }
    }

    public InfoDialog getPropertyAt(Point point, TimeBoundingBox timeBoundingBox) {
        Drawable drawable;
        Drawable drawable2;
        CoordPixelImage coordPixelImage = new CoordPixelImage(this, this.row_height, super.getTimeBoundsOfImages());
        double d = coordPixelImage.convertPixelToTime(point.x);
        Map map = this.y_maps.getMapOfLineIDToTreeLeaf();
        Map map2 = this.y_maps.getMapOfLineIDToRowID();
        if (map2 == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(this.root_frame, "Error in updating YaxisMaps!");
            }
            map2 = this.y_maps.getMapOfLineIDToRowID();
        }
        Iterator iterator = this.treetrunk.iteratorOfAllDrawables(timeBoundingBox, DECRE_STARTTIME_ORDER, this.isConnectedComposite, false);
        while (iterator.hasNext()) {
            drawable2 = (Drawable)iterator.next();
            if (!drawable2.getCategory().isVisible() || (drawable = drawable2.getDrawableAt(coordPixelImage, map2, point)) == null || !drawable.getCategory().isVisible()) continue;
            return new InfoDialogForDrawable(this.root_frame, d, map, this.y_colnames, drawable);
        }
        Iterator iterator2 = this.treetrunk.iteratorOfLowestFloorShadows(timeBoundingBox, DECRE_STARTTIME_ORDER, true);
        while (iterator2.hasNext()) {
            Shadow shadow = (Shadow)iterator2.next();
            if (!shadow.getCategory().isVisible() || (drawable = shadow.getDrawableAt(coordPixelImage, map2, point)) == null || !drawable.getCategory().isVisible()) continue;
            return new InfoDialogForDrawable(this.root_frame, d, map, this.y_colnames, drawable);
        }
        iterator = this.treetrunk.iteratorOfRealDrawables(timeBoundingBox, DECRE_STARTTIME_ORDER, this.isConnectedComposite, true);
        while (iterator.hasNext()) {
            drawable2 = (Drawable)iterator.next();
            if (!drawable2.getCategory().isVisible() || (drawable = drawable2.getDrawableAt(coordPixelImage, map2, point)) == null || !drawable.getCategory().isVisible()) continue;
            return new InfoDialogForDrawable(this.root_frame, d, map, this.y_colnames, drawable);
        }
        return super.getTimePropertyAt(point);
    }

    public Rectangle localRectangleForDrawable(Drawable drawable) {
        CoordPixelImage coordPixelImage = new CoordPixelImage(this, this.row_height, super.getTimeBoundsOfImages());
        int n = coordPixelImage.convertTimeToPixel(drawable.getEarliestTime());
        int n2 = coordPixelImage.convertTimeToPixel(drawable.getLatestTime()) - n;
        int n3 = drawable.getRowID();
        float f = drawable.getNestingFactor();
        float f2 = (float)n3 - f / 2.0f;
        float f3 = f2 + f;
        int n4 = coordPixelImage.convertRowToPixel(f2);
        int n5 = coordPixelImage.convertRowToPixel(f3) - n4;
        Rectangle rectangle = new Rectangle(n, n4, n2, n5);
        return rectangle;
    }

    private InfoPanelForDrawable createInfoPanelForDrawable(Drawable drawable) {
        Map map = this.y_maps.getMapOfLineIDToTreeLeaf();
        InfoPanelForDrawable infoPanelForDrawable = new InfoPanelForDrawable(map, this.y_colnames, drawable);
        return infoPanelForDrawable;
    }

    public SearchPanel searchPreviousComponent(double d) {
        Drawable drawable = this.tree_search.previousDrawable(d);
        if (drawable != null) {
            return this.createInfoPanelForDrawable(drawable);
        }
        return null;
    }

    public SearchPanel searchPreviousComponent() {
        Drawable drawable = this.tree_search.previousDrawable();
        if (drawable != null) {
            return this.createInfoPanelForDrawable(drawable);
        }
        return null;
    }

    public SearchPanel searchNextComponent(double d) {
        Drawable drawable = this.tree_search.nextDrawable(d);
        if (drawable != null) {
            return this.createInfoPanelForDrawable(drawable);
        }
        return null;
    }

    public SearchPanel searchNextComponent() {
        Drawable drawable = this.tree_search.nextDrawable();
        if (drawable != null) {
            return this.createInfoPanelForDrawable(drawable);
        }
        return null;
    }

    public InitializableDialog createSummary(Dialog dialog, TimeBoundingBox timeBoundingBox) {
        BufForTimeAveBoxes bufForTimeAveBoxes = this.tree_search.createBufForTimeAveBoxes(timeBoundingBox);
        return new StatlineDialog(dialog, timeBoundingBox, this.y_maps.getLineIDMap(), bufForTimeAveBoxes);
    }
}

