/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import logformat.slog2.input.InputLog;
import viewer.common.Dialogs;
import viewer.common.TopWindow;
import viewer.legends.LegendPanel;

public class LegendFrame
extends JFrame {
    private static final long serialVersionUID = 3000L;
    private static String in_filename;
    private LegendPanel top_panel;
    private static String help_msg;

    public LegendFrame(InputLog inputLog) {
        super("Legend : " + inputLog.getPathnameSuffix());
        super.setDefaultCloseOperation(0);
        TopWindow.Legend.disposeAll();
        TopWindow.Legend.setWindow(this);
        this.top_panel = new LegendPanel(inputLog);
        super.setContentPane(this.top_panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LegendFrame.this.setVisible(false);
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        TopWindow.Control.setShowLegendButtonEnabled(!bl);
    }

    public static void main(String[] stringArray) {
        String string;
        LegendFrame.checkVersion();
        LegendFrame.parseCmdLineArgs(stringArray);
        System.out.print("Reading the SLOG-2 file ...... ");
        InputLog inputLog = new InputLog(in_filename);
        System.out.println("Done.");
        if (inputLog == null) {
            Dialogs.error(null, "Null InputLog!!");
            inputLog = null;
            System.exit(1);
        }
        if (!inputLog.isSLOG2()) {
            Dialogs.error(null, in_filename + " is NOT a SLOG-2 file!");
            inputLog = null;
            System.exit(1);
        }
        if ((string = inputLog.getCompatibleHeader()) != null && !Dialogs.confirm(null, string + "Check the following version history " + "for compatibility.\n\n" + "- Version SLOG 2.0.0's node employs\n  decreasing endtime ordering.\n- Version SLOG 2.0.1's node employs\n  increasing starttime ordering.\n- Version SLOG 2.0.2 added preview data\n  in legend order to shadow states.\n- Version SLOG 2.0.3 changed preview data\n  from legend to inclusive ratio order.\n- Version SLOG 2.0.4 removed unused\n  category objects.\n- Version SLOG 2.0.5 expanded preview data\n  to include inclusive & exclusive ratios.\n- Version SLOG 2.0.6 expanded preview data\n  to include the count of real drawables.\n  \n- 2.0.1 viewer draws 2.0.0 logfile's\n  state nesting stack incorrectly!\n- 2.0.2 viewer cannot read 2.0.1 logfile.\n- 2.0.3 viewer draws 2.0.2 logfile's\n  preview weight incorrectly.\n- 2.0.4 viewer supports JOIN method and\n  can display 2.0.3 logfile correctly.\n- 2.0.5 viewer cannot read 2.0.4 logfile.\n- 2.0.6 viewer cannot read 2.0.5 logfile.\n" + "\n" + "Do you still want to continue reading " + "the logfile ?")) {
            inputLog = null;
            System.exit(1);
        }
        System.out.println("Starting the SLOG-2 Legend .... ");
        inputLog.initialize();
        LegendFrame legendFrame = new LegendFrame(inputLog);
        legendFrame.pack();
        legendFrame.setVisible(true);
    }

    public static void checkVersion() {
        String string = System.getProperty("java.version");
        System.out.println("Java is version " + string + ".");
        if (string.compareTo("1.2.0") < 0) {
            System.err.println("WARNING: Java is version " + string + ". \n" + "\t It is too old to run this prototype.");
        }
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + LegendFrame.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + LegendFrame.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        help_msg = "Usage: java viewer.legends.LegendFrame [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]                 \t Display this message.\n";
    }
}

