/*
 * Decompiled with CFR 0.152.
 */
package logformat.trace;

import base.drawable.Category;
import base.drawable.Composite;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;

public class InputLog {
    private String filespec;
    private long filehandle;
    private int num_topology_returned;

    public InputLog(String string) {
        this.filespec = string;
        boolean bl = this.open();
        if (this.filehandle == 0L) {
            if (bl) {
                System.out.println("trace.InputLog.open() exits normally!");
                System.exit(0);
            } else {
                System.err.println("trace.InputLog.open() fails!\nNo slog2 file is generated due to previous errors.");
                System.exit(1);
            }
        }
        this.num_topology_returned = 0;
    }

    private static native void initIDs();

    public native boolean open();

    public native boolean close();

    public native int peekNextKindIndex();

    public native Category getNextCategory();

    public native YCoordMap getNextYCoordMap();

    public native Primitive getNextPrimitive();

    public native Composite getNextComposite();

    public Kind peekNextKind() {
        if (this.num_topology_returned < 3) {
            return Kind.TOPOLOGY;
        }
        int n = this.peekNextKindIndex();
        switch (n) {
            case -1: {
                return Kind.TOPOLOGY;
            }
            case 0: {
                return Kind.EOF;
            }
            case 1: {
                return Kind.PRIMITIVE;
            }
            case 2: {
                return Kind.COMPOSITE;
            }
            case 3: {
                return Kind.CATEGORY;
            }
            case 4: {
                return Kind.YCOORDMAP;
            }
        }
        System.err.println("trace.InputLog.peekNextKind(): Unknown value, " + n);
        return null;
    }

    public Topology getNextTopology() {
        switch (this.num_topology_returned) {
            case 0: {
                this.num_topology_returned = 1;
                return Topology.EVENT;
            }
            case 1: {
                this.num_topology_returned = 2;
                return Topology.STATE;
            }
            case 2: {
                this.num_topology_returned = 3;
                return Topology.ARROW;
            }
        }
        System.err.println("All Topology Names have been returned");
        return null;
    }

    static {
        InputLog.initIDs();
    }
}

