/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import logformat.clog.MixedDataInputStream;

public class InputLog {
    private static final int BLOCKSIZE = 65536;
    private String filename;
    private DataInputStream main_ins;
    private byte[] buffer;

    public InputLog(String string) {
        this.filename = string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(0);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
        this.main_ins = new DataInputStream(bufferedInputStream);
        this.buffer = null;
    }

    public String getFileName() {
        return this.filename;
    }

    public MixedDataInputStream getBlockStream() {
        if (this.main_ins == null) {
            System.err.println("Error: input_stream.main_ins == null !!");
            return null;
        }
        if (this.buffer == null) {
            this.buffer = new byte[65536];
        }
        try {
            this.main_ins.readFully(this.buffer);
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return new MixedDataInputStream(new ByteArrayInputStream(this.buffer));
    }

    public void close() {
        try {
            this.main_ins.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

