/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.TimeBoundingBox;
import base.io.BufArrayOutputStream;
import base.io.MixedDataIO;
import base.io.MixedDataOutputStream;
import base.io.MixedRandomAccessFile;
import java.io.IOException;
import logformat.slog2.CategoryMap;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.Header;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.TreeNodeID;
import logformat.slog2.output.TreeNode;

public class OutputLog {
    private MixedRandomAccessFile rand_file = null;
    private BufArrayOutputStream bary_outs;
    private MixedDataOutputStream data_outs;
    private Header filehdr;
    private TreeDir treedir;
    private FileBlockPtr node_blockptr;

    public OutputLog(String string) {
        try {
            this.rand_file = new MixedRandomAccessFile(string, "rw");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        this.filehdr = new Header();
        this.bary_outs = new BufArrayOutputStream(this.filehdr.getTreeLeafByteSize());
        this.data_outs = new MixedDataOutputStream(this.bary_outs);
        this.treedir = new TreeDir();
        this.node_blockptr = null;
        this.writeHeader();
    }

    public void setTreeLeafByteSize(int n) {
        this.filehdr.setTreeLeafByteSize(n);
        this.bary_outs = new BufArrayOutputStream(this.filehdr.getTreeLeafByteSize());
        this.data_outs = new MixedDataOutputStream(this.bary_outs);
    }

    public int getTreeLeafByteSize() {
        return this.filehdr.getTreeLeafByteSize();
    }

    public void setNumChildrenPerNode(short s) {
        this.filehdr.setNumChildrenPerNode(s);
    }

    public short getNumChildrenPerNode() {
        return this.filehdr.getNumChildrenPerNode();
    }

    public void writeTreeNode(TreeNode treeNode) {
        try {
            this.node_blockptr = new FileBlockPtr(this.rand_file.getFilePointer(), treeNode.getNodeByteSize());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        TreeNodeID treeNodeID = new TreeNodeID(treeNode.getTreeNodeID());
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox(treeNode);
        TreeDirValue treeDirValue = new TreeDirValue(timeBoundingBox, this.node_blockptr);
        this.treedir.put(treeNodeID, treeDirValue);
        treeNode.setFileBlockPtr(this.node_blockptr.getFilePointer(), this.node_blockptr.getBlockSize());
        treeNode.mergeVerticalShadowBufs();
        treeNode.shiftHorizontalShadowBuf();
        this.bary_outs.reset();
        try {
            treeNode.writeObject(this.data_outs);
            this.data_outs.flush();
            this.rand_file.write(this.bary_outs.getByteArrayBuf(), 0, this.bary_outs.size());
            if (this.bary_outs.size() > this.filehdr.getMaxBufferByteSize()) {
                this.filehdr.setMaxBufferByteSize(this.bary_outs.size());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private void writeFilePart(MixedDataIO mixedDataIO, FileBlockPtr fileBlockPtr) {
        int n = 0;
        try {
            fileBlockPtr.setFilePointer(this.rand_file.getFilePointer());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        this.bary_outs.reset();
        try {
            mixedDataIO.writeObject(this.data_outs);
            this.data_outs.flush();
            this.rand_file.write(this.bary_outs.getByteArrayBuf(), 0, this.bary_outs.size());
            if (this.bary_outs.size() > this.filehdr.getMaxBufferByteSize()) {
                this.filehdr.setMaxBufferByteSize(this.bary_outs.size());
            }
            n = (int)(this.rand_file.getFilePointer() - fileBlockPtr.getFilePointer());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        fileBlockPtr.setBlockSize(n);
    }

    public void writeCategoryMap(CategoryMap categoryMap) {
        this.writeFilePart(categoryMap, this.filehdr.blockptr2categories);
    }

    public void writeLineIDMapList(LineIDMapList lineIDMapList) {
        this.writeFilePart(lineIDMapList, this.filehdr.blockptr2lineIDmaps);
    }

    private void writeTreeDir() {
        this.writeFilePart(this.treedir, this.filehdr.blockptr2treedir);
    }

    private void writeHeader() {
        if (this.node_blockptr != null) {
            this.filehdr.blockptr2treeroot.setFileBlockPtr(this.node_blockptr.getFilePointer(), this.node_blockptr.getBlockSize());
            this.filehdr.setMaxTreeDepth(this.treedir.getTreeRootID().depth);
        }
        this.bary_outs.reset();
        try {
            this.filehdr.writeObject(this.data_outs);
            this.data_outs.flush();
            this.rand_file.seek(0L);
            this.rand_file.write(this.bary_outs.getByteArrayBuf(), 0, this.bary_outs.size());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public void close() {
        this.writeTreeDir();
        this.writeHeader();
        System.out.println(this.filehdr.toString());
        try {
            this.data_outs.close();
            this.rand_file.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

