/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.drawable.Composite;
import base.drawable.Coord;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.Shadow;
import base.drawable.Topology;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import viewer.common.Const;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.legends.CategoryLabel;
import viewer.zoomable.SearchPanel;
import viewer.zoomable.TimeFormat;
import viewer.zoomable.YaxisTreeNode;

public class InfoPanelForDrawable
extends SearchPanel {
    private static final Component STRUT = Box.createHorizontalStrut(10);
    private static final Component GLUE = Box.createHorizontalGlue();
    private static final String FORMAT = "#,##0.000000####";
    private static DecimalFormat fmt = null;
    private static TimeFormat tfmt = null;
    private static Border Normal_Border = null;
    private static Border Shadow_Border = null;
    private Drawable drawable;

    public InfoPanelForDrawable(Map map, String[] stringArray, Drawable drawable) {
        super.setLayout(new BoxLayout(this, 1));
        if (fmt == null) {
            fmt = (DecimalFormat)NumberFormat.getInstance();
            fmt.applyPattern(FORMAT);
        }
        if (tfmt == null) {
            tfmt = new TimeFormat();
        }
        if (Normal_Border == null) {
            Normal_Border = BorderFactory.createEtchedBorder();
        }
        if (Shadow_Border == null) {
            Shadow_Border = BorderFactory.createTitledBorder(Normal_Border, " Preview State ", 1, 2, Const.FONT, Color.magenta);
        }
        this.drawable = drawable;
        Category category = null;
        CategoryLabel categoryLabel = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (this.drawable instanceof Shadow && ((Shadow)this.drawable).getSelectedSubCategory() != null) {
            category = ((Shadow)this.drawable).getSelectedSubCategory();
            categoryLabel = new CategoryLabel(category);
            ((Shadow)this.drawable).clearSelectedSubCategory();
            jPanel.setBorder(Shadow_Border);
        } else {
            category = this.drawable.getCategory();
            categoryLabel = new CategoryLabel(category);
            jPanel.setBorder(Normal_Border);
        }
        jPanel.add(STRUT);
        jPanel.add(categoryLabel);
        jPanel.add(GLUE);
        jPanel.setAlignmentX(0.0f);
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        jPanel.setMaximumSize(dimension);
        super.add(jPanel);
        TextAreaBuffer textAreaBuffer = new TextAreaBuffer(map, stringArray);
        if (this.drawable instanceof Shadow) {
            textAreaBuffer.setShadowText((Shadow)this.drawable, category);
        } else if (this.drawable instanceof Composite) {
            textAreaBuffer.setCompositeText((Composite)this.drawable);
        } else {
            textAreaBuffer.setPrimitiveText((Primitive)this.drawable);
        }
        textAreaBuffer.finalized();
        int n = textAreaBuffer.getColumnCount();
        int n2 = textAreaBuffer.getRowCount();
        JTextArea jTextArea = new JTextArea(textAreaBuffer.toString());
        int n3 = Routines.getAdjNumOfTextColumns(jTextArea, n);
        n = (int)Math.ceil((double)n3 * 85.0 / 100.0);
        jTextArea.setColumns(n);
        jTextArea.setRows(n2);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setAlignmentX(0.0f);
        super.add(jScrollPane);
    }

    public Drawable getSearchedDrawable() {
        return this.drawable;
    }

    private class TextAreaBuffer {
        private Map map_line2treenodes;
        private String[] y_colnames;
        private StringBuffer strbuf;
        private String strbuf2str;
        private int num_cols;
        private int num_rows;

        public TextAreaBuffer(Map map, String[] stringArray) {
            this.map_line2treenodes = map;
            this.y_colnames = stringArray;
            this.strbuf = new StringBuffer();
            this.strbuf2str = null;
            this.num_cols = 0;
            this.num_rows = 0;
        }

        public void finalized() {
            this.strbuf2str = this.strbuf.toString();
            int n = this.getNumOfLines();
            this.num_rows = n <= 3 ? 3 : 4;
        }

        public int getColumnCount() {
            return this.num_cols;
        }

        public int getRowCount() {
            return this.num_rows;
        }

        public String toString() {
            return this.strbuf2str;
        }

        private int getNumOfLines() {
            if (this.strbuf2str != null) {
                int n = 1;
                int n2 = 0;
                int n3 = this.strbuf2str.length();
                while (n2 >= 0 && n2 < n3) {
                    if ((n2 = this.strbuf2str.indexOf(10, n2)) < 0) continue;
                    ++n;
                    ++n2;
                }
                return n;
            }
            return -1;
        }

        private void setCoordsText(Coord[] coordArray, String string) {
            int n = coordArray.length;
            double d = coordArray[n - 1].time - coordArray[0].time;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("duration" + string + " = " + tfmt.format(d));
            if (this.num_cols < stringBuffer.length()) {
                this.num_cols = stringBuffer.length();
            }
            ++this.num_rows;
            this.strbuf.append(stringBuffer.toString());
            for (int i = 0; i < n; ++i) {
                stringBuffer = new StringBuffer("[" + i + "]: ");
                Coord coord = coordArray[i];
                Integer n2 = new Integer(coord.lineID);
                YaxisTreeNode yaxisTreeNode = (YaxisTreeNode)this.map_line2treenodes.get(n2);
                TreeNode[] treeNodeArray = yaxisTreeNode.getPath();
                stringBuffer.append("time" + string + " = " + fmt.format(coord.time));
                for (int j = 1; j < treeNodeArray.length; ++j) {
                    stringBuffer.append(", " + this.y_colnames[j - 1] + " = " + treeNodeArray[j]);
                }
                if (this.num_cols < stringBuffer.length()) {
                    this.num_cols = stringBuffer.length();
                }
                ++this.num_rows;
                this.strbuf.append("\n" + stringBuffer.toString());
            }
        }

        private void setEndCoordsText(Coord coord, Coord coord2, double d, double d2, int n) {
            int n2;
            double d3 = d2 - d;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("duration (max) = " + tfmt.format(d3));
            if (this.num_cols < stringBuffer.length()) {
                this.num_cols = stringBuffer.length();
            }
            ++this.num_rows;
            this.strbuf.append(stringBuffer.toString());
            int n3 = 0;
            stringBuffer = new StringBuffer("[" + n3 + "]: ");
            Coord coord3 = coord;
            Integer n4 = new Integer(coord3.lineID);
            YaxisTreeNode yaxisTreeNode = (YaxisTreeNode)this.map_line2treenodes.get(n4);
            TreeNode[] treeNodeArray = yaxisTreeNode.getPath();
            stringBuffer.append("time (min) = " + fmt.format(d));
            for (n2 = 1; n2 < treeNodeArray.length; ++n2) {
                stringBuffer.append(", " + this.y_colnames[n2 - 1] + " = " + treeNodeArray[n2]);
            }
            if (this.num_cols < stringBuffer.length()) {
                this.num_cols = stringBuffer.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + stringBuffer.toString());
            n3 = n - 1;
            stringBuffer = new StringBuffer("[" + n3 + "]: ");
            coord3 = coord2;
            n4 = new Integer(coord3.lineID);
            yaxisTreeNode = (YaxisTreeNode)this.map_line2treenodes.get(n4);
            treeNodeArray = yaxisTreeNode.getPath();
            stringBuffer.append("time (max) = " + fmt.format(d2));
            for (n2 = 1; n2 < treeNodeArray.length; ++n2) {
                stringBuffer.append(", " + this.y_colnames[n2 - 1] + " = " + treeNodeArray[n2]);
            }
            if (this.num_cols < stringBuffer.length()) {
                this.num_cols = stringBuffer.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + stringBuffer.toString());
        }

        public void setPrimitiveText(Primitive primitive) {
            Drawable drawable;
            this.setCoordsText(primitive.getVertices(), "");
            String string = primitive.toInfoBoxString().trim();
            if (string.length() > 0) {
                this.strbuf.append("\n" + string);
                ++this.num_rows;
            }
            if ((drawable = primitive.getParent()) != null && (string = drawable.toInfoBoxString().trim()).length() > 0) {
                this.strbuf.append("\n" + string);
                ++this.num_rows;
            }
        }

        private int getPrintStatus(Topology topology) {
            if (topology.isState()) {
                if (Parameters.PREVIEW_STATE_DISPLAY.equals("CumulativeExclusionRatio") || Parameters.PREVIEW_STATE_DISPLAY.equals("OverlapExclusionRatio")) {
                    return 2;
                }
                return 1;
            }
            return 1;
        }

        public void setShadowText(Shadow shadow, Category category) {
            this.setEndCoordsText(shadow.getStartVertex(), shadow.getFinalVertex(), shadow.getEarliestTime(), shadow.getLatestTime(), shadow.getVertices().length);
            this.strbuf.append("\n\n");
            this.setCoordsText(shadow.getVertices(), " (ave)");
            this.strbuf.append("\n");
            StringBuffer stringBuffer = new StringBuffer("Number of Real Drawables = ");
            stringBuffer.append(shadow.getNumOfRealObjects());
            if (this.num_cols < stringBuffer.length()) {
                this.num_cols = stringBuffer.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + stringBuffer.toString());
            this.strbuf.append("\n");
            int n = this.getPrintStatus(shadow.getCategory().getTopology());
            this.strbuf.append("\n" + CategoryWeight.getPrintTitle(n));
            CategoryWeight[] categoryWeightArray = shadow.arrayOfCategoryWeights();
            for (int i = 0; i < categoryWeightArray.length; ++i) {
                CategoryWeight categoryWeight = categoryWeightArray[i];
                String string = categoryWeight.toInfoBoxString(n);
                if (categoryWeight.getCategory().equals(category)) {
                    if (this.num_cols < (string = string + "  <---").length() + 6) {
                        this.num_cols = string.length() + 6;
                    }
                } else if (this.num_cols < string.length()) {
                    this.num_cols = string.length();
                }
                ++this.num_rows;
                this.strbuf.append("\n" + string);
            }
        }

        public void setCompositeText(Composite composite) {
            Drawable drawable;
            Coord[] coordArray = new Coord[]{composite.getStartVertex(), composite.getFinalVertex()};
            this.setCoordsText(coordArray, "");
            String string = composite.toInfoBoxString().trim();
            if (string.length() > 0) {
                this.strbuf.append("\n" + string);
                ++this.num_rows;
            }
            if ((drawable = composite.getParent()) != null && (string = drawable.toInfoBoxString().trim()).length() > 0) {
                this.strbuf.append("\n" + string);
                ++this.num_rows;
            }
        }
    }
}

