
/*
 * @(#)mimep.h 1.2 01/01/23
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MIMEP_MIMEP_H__
#define __MIMEP_MIMEP_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xos.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include "lineopts.h"
#include "error.h"
#include "../../common/option.h"
#include "../../mp/header.h"
#include "../../mp/input.h"
#include "../../mp/print.h"

#define FFLUSH            (void) fflush
#define PUTENV            (void) putenv
#define SYSTEM            (void) system

/* Parameters of the output document */

#define NONE              " none"
#define UNKNOWN           "unknown"
#define TITLEH_FROM       "Message from:"
#define H_FROM            "From:"
#define TITLEH_TO         "Message for "
#define H_TO              "To:"
#define TITLEH_SUBJECT    "Subject:"
#define H_SUBJECT         "Subject:"
#define TITLEH_DATE       "Date:"
#define H_DATE            "Date:"
#define H_CC              "Cc:"
#define H_APPFROM         "Apparently-From:"
#define H_APPTO           "Apparently-To:"
#define H_NEWSGROUP       "Newsgroup:"
#define H_REPLY           "Reply-To:"
#define ODDSIDEMARGIN     -12
#define TOPMARGIN         -30
#define HEADHEIGHT        0
#define HEADSEP           0
#define FOOTSKIP          6
#define A4TEXTHEIGHT      770
#define USTEXTHEIGHT      718
#define FBOXSEP           8    /* >3 */
#define SEP1              10
#define SEP2              20

static int MAXTFROM = 0;

#define ITEMSEP           -4
#define RULEH             "1.250"
#define BOXLINECOLOR      0.000    /* (black) from greyscale */
#define BOXBCKGRDCOLOR    0.929    /* from grey scale */

#define TEXTWIDTH         498.75/* optimum */
#define BOXLENGTH         491.95

#define A4PAPER           "a4paper"
#define USPAPER           "letterpaper"
#define TMPREFIX          "MIMEP"
#define MMPREFIX          "mm."
#define NOOUTPUTFILE      "nofile"
#define MAXARRAY          512
#define MIMEPOUT          "MIMEPOUT="
#define MIMEPBOUND        "MIMEPBOUND="
#define MIMEPMAXCH        "MIMEPMAXCH="
#define MIMEPRULEH        "MIMEPRULEH="
#define MIMEPPRINT        "MIMEPPRINTER="
#define MIMEPMAILCAP      "MAILCAPS="
#define MIMEPTMPDIR       "MIMEPTMPDIR"
#define DEFTMPDIR         "/tmp"
#define DEFAULTB          "default"
#define NOB               "none"
#define MINTSIZE          10
#define MAXTSIZE          12
#define EOS               '\0'
#define SLASH             '/'
#define SLASHSTR          "/"
#define POINT             '.'
#define MAXF              75
#define FP(param)         (void) fprintf(fp_out, "%s\n", param)

/* Pieces of command lines */

#define METAMAIL          "metamail -h -q "
#define LATEX             "latex "
#define LPR               "lpr "
#define DVIPS             "dvips -q "
#define RM                "/bin/rm "
#define DVIPSO            " -o "
#define TOPRINTER         "'!lpr"
#define DVIPSF            " -f"
#define LPRP              " -P"
#define LPRH              " -h "
#define SPACESTR          " "
#define ENDVIPSO          "'"
#define TONULL            " >/dev/null"
#define PSSUFFIX          ".ps"
#define DVISUFFIX         ".dvi"
#define AUXSUFFIX         ".aux"
#define LOGSUFFIX         ".log"
#define STAR              "*"

static FILE *fp_in, *fp_out;

static int  argc;
static char **argv;

static bool printpagenum;

static char *printername;
static bool burstpage;
static bool toprinter;
static bool tofile;
static bool tostdout;
static char *TMPDIR;

/* Usage of the command */

static char *args[] = {
    "mimep",                /* program name */
    "[source_file]",
    "[-o target_file]",
    "[-f]",
    "[-fp]",
    "[-printer printername]",
    "[-a4]",
    "[-us]",
    "[-typesize size]",
    "[-noburstpage]",
    "[-nopagenum]",
    "[-addhdrs headertype...]",
    "[-rmhdrs headertype...]",
    "[-allheaders]",
    "[-boundary filename|default|none]",
    "[-mailcap filename]",
    NULL
};

/* Comments added to the usage */
static char *comments[] =
{
    "MIMEP by Mikael CAM for the CRI of Rennes1 and the internet community...",
    "MIMEP, the Multimedia Internet Message printer!",
    NULL
};

static char *nbmaxcar[] =
{
    "95",   /* Max length of a line in US or A4 format with a 10pt type size */
    "86",   /* Same with a 11pt type size */
    "80"    /* ............12pt.......... */
};

/* LaTeX' special symbols */

static char *specar[] = {
    "$", "\\$",
    "&", "\\&",
    "%", "\\%",
    "#", "\\#",
    "_", "\\_",
    "{", "\\{",
    "}", "\\}",
    "\\", "$\\backslash$",
    "|", "$|$",
    "<", "$<$",
    ">", "$>$",
    "~", "$\\sim$",
    "^", "$\\wedge$",
    NULL, NULL
};

static void latex_header    (void);
static char *inputfilename  (void);
static void mk_headers      (void);
static char *outputfilename (void);
static bool istoprint       (char *);
static void latex_enddoc    (void);
static char *removesuffix   (char *);
static void maxcarnb        (int);
static char *text2latex     (char *);
static char *getdir         (char *);
static void treat_options   (void);
static void clean           (void);

#endif /* __MIMEP_MIMEP_H__ */
