
/*
 * @(#)comliste.c 1.2 01/01/23
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Module  : comliste.c   Auteur               : Mikael CAM
 * Cadre   : Projet Mimep  Derniere M.A.J.     :
 * 
 * Version : OK
 * 
 * Objet   : Gestion de la liste des dernieres commandes  de texte enrichi.
 */

#include "comliste.h"

#define  TRUE   1
#define  FALSE  0

static int _TRACE = 0;

/* $PROCEDURE CreeListe: Creation de la liste des commandes. */

void 
CreeListe(Liste_com *l)
{
    l->courant = NULL;
    l->tete    = NULL;
    l->queue   = NULL;
}


/* $PROCEDURE suivant: Positionnement sur le suivant dans la liste. */

static format_com *
suivant(Liste_com *l)
{
    if (l->courant != l->queue) {
        l->courant = l->courant->suivant;
    }

    return(l->courant);
}


/* $PROCEDURE courant: Renvoie un pointeur sur l'element courant. */

format_com *
courant(Liste_com *l)
{
    return(l->courant);
}


/* $PROCEDURE position_tete: Positionnement sur la tete de liste. */

format_com *
position_tete(Liste_com *l)
{
    l->courant = l->tete;

    return(l->tete);
}


/* $PROCEDURE AjouteListe: Ajout d'un element dans la liste. */

void 
AjouteListe(Liste_com *l, format_com *p)
{
    if (l->tete == NULL) {
        l->tete = p;
        l->queue = p;
        l->courant = p;
    }

    l->queue->suivant = p;
    p->precedent = l->queue;
    l->queue = p;
}


/* $PROCEDURE OteEltListe: Ote un element dans la liste. */

void 
OteEltListe(Liste_com * l, format_com * p)
{
    if ((p != l->tete) && (p != l->queue)) {
        p->precedent->suivant = p->suivant;
        p->suivant->precedent = p->precedent;
        FREE(p);
    } else if ((p == l->queue) && (p != l->tete)) {
        p->precedent->suivant = NULL;
        l->queue = p->precedent;
        FREE(p);
    } else if ((p == l->tete) && (p != l->queue)) {
        p->suivant->precedent = NULL;
        l->tete = p->suivant;
        FREE(p);
    } else {
        l->tete = NULL;
        l->queue = NULL;
        l->courant = NULL;
        /* FREE(p); */
    }
}


/* $PROCEDURE FinListe: Verifie si l'on est en fin de liste. */

int 
FinListe(Liste_com *l)
{
    if (l->courant == l->queue) {
        return(TRUE);
    } else {
        return(FALSE);
    }
}


/* $PROCEDURE remplie_param: Remplie les parametres d'un element de la liste. */

/* ARGSUSED */
void 
remplie_comm(format_com *p, Command c, Liste_com *l)
{
    Command commande = (Command) malloc((sizeof(char)) * strlen(c));

    STRCPY(commande, c);
    p->c_name = commande;
}


/* $PROCEDURE Trouve: essaie de trouver un element donne de la liste
 *                    correspondant a la fenetre passee en parametres.
 */

format_com *
Trouve(Command c, Liste_com *l)
{
    format_com *cp_cour;
    int existe;

/* Recherche des derniers parametres de la fenetre concernee */

    if (_TRACE) {
        FPRINTF(stdout, " Recherche \n");
    }

    existe = FALSE;
    cp_cour = position_tete(l);

    if ((cp_cour) && (!strcmp(cp_cour->c_name, c))) {
        existe = TRUE;
    } else {
        while ((!FinListe(l)) && (!existe)) {
            cp_cour = suivant(l);

            if (!strcmp(cp_cour->c_name, c)) {
                existe = TRUE;
            }

            if (_TRACE) {
                FPRINTF(stdout, " Recherche: Command: %s\n", cp_cour->c_name);
            }
        }
    }

    if (existe) {
        return(cp_cour);
    } else {
        return(NULL);
    }
}
