# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2008-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors: Benjamin Kampmann <benjamin@fluendo.com>
#          Olivier Tilloy <olivier@fluendo.com>

"""
A simple import and initialize test for the base models.
"""

from elisa.core.media_uri import MediaUri

from elisa.plugins.base.models import audio, video, image, media, network, \
                                      plugin

from twisted.trial.unittest import TestCase


class ModelMixin(object):

    module = None

    def test_import_and_initialize(self):
        models = filter(lambda x: x.endswith('Model'), dir(self.module))
        for model_name in models:
            model_class = getattr(self.module, model_name)
            obj = model_class()


class TestAudioModels(TestCase, ModelMixin):

    module = audio


class TestVideoModels(TestCase, ModelMixin):

    module = video


class TestImageModels(TestCase, ModelMixin):

    module = image


class TestMediaModels(TestCase, ModelMixin):

    module = media

class TestNetworkModels(TestCase, ModelMixin):

    module = network


class TestPluginModels(TestCase, ModelMixin):

    module = plugin

    def test_from_dict(self):
        dictionary = {}
        dictionary['icons'] = str([{'uri': 'icon1'}, {'uri': 'icon2'}])
        model = plugin.PluginModel.from_dict(dictionary)
        self.failUnlessEqual(len(model.icons), 2)
        self.failUnless(isinstance(model.icons[0], image.ImageModel))
        self.failUnlessEqual(len(model.icons[0].references), 1)
        self.failUnlessEqual(model.icons[0].references[0], MediaUri('icon1'))
        self.failUnless(isinstance(model.icons[1], image.ImageModel))
        self.failUnlessEqual(len(model.icons[1].references), 1)
        self.failUnlessEqual(model.icons[1].references[0], MediaUri('icon2'))

    def test_from_distribution(self):
        raise NotImplementedError()

    test_from_distribution.todo = 'Implement me!'
