/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import sharpen.core.csharp.ast.CSExpression;
import sharpen.core.csharp.ast.CSFieldModifier;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;
import sharpen.core.csharp.ast.CSTypedMember;
import sharpen.core.csharp.ast.CSVisibility;
import sharpen.core.csharp.ast.CSVisitor;

public class CSField
extends CSTypedMember {
    private CSExpression _initializer;
    private Set<CSFieldModifier> _modifiers = new LinkedHashSet<CSFieldModifier>();

    public CSField(String name, CSTypeReferenceExpression type, CSVisibility visibility) {
        this(name, type, visibility, null);
    }

    public CSField(String name, CSTypeReferenceExpression type, CSVisibility visibility, CSExpression initializer) {
        super(name, type);
        this._visibility = visibility;
        this._initializer = initializer;
    }

    @Override
    public void accept(CSVisitor visitor) {
        visitor.visit(this);
    }

    public CSExpression initializer() {
        return this._initializer;
    }

    public void initializer(CSExpression initializer) {
        this._initializer = initializer;
    }

    public void addModifier(CSFieldModifier modifier) {
        this._modifiers.add(modifier);
    }

    public void removeModifier(CSFieldModifier modifier) {
        this._modifiers.remove((Object)modifier);
    }

    public Set<CSFieldModifier> modifiers() {
        return Collections.unmodifiableSet(this._modifiers);
    }
}

