#ifndef _M_TREE_H_
#define _M_TREE_H_

#include "mdatatypes.h"

typedef struct mtree{
	struct mtree *parent;
	struct mtree **childs;
	mdata *data;
	
	int num_childs;
} mtree;

mtree * mtree_init();
int mtree_add_child(mtree *t, mtree *child) ;
mtree * mtree_search(mtree *t, const char *name);
void mtree_free(mtree *t);
int mtree_is_empty(const mtree *t);
int mtree_print(const mtree *t);
int mtree_is_child(const mtree *t, const char *name);
int mtree_num_elements(const mtree *t);

#endif
